/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorException;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.utils.TensorUtils;

public class ExpressionFactory
implements TensorFactory {
    public static final ExpressionFactory FACTORY = new ExpressionFactory();

    private ExpressionFactory() {
    }

    @Override
    public Expression create(Tensor ... tensors) {
        if (tensors.length != 2) {
            throw new IllegalArgumentException("Wrong number of arguments.");
        }
        if (tensors[0] == null || tensors[1] == null) {
            throw new NullPointerException();
        }
        if (!(TensorUtils.isZero(tensors[1]) || TensorUtils.isIndeterminate(tensors[1]) || tensors[0].getIndices().getFree().equalsRegardlessOrder(tensors[1].getIndices().getFree()))) {
            throw new TensorException("Inconsistent indices in expression.");
        }
        return new Expression(IndicesFactory.create(tensors[0].getIndices().getFree()), tensors[0], tensors[1]);
    }
}

