/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indexgenerator.IndexGeneratorFromData;
import cc.redberry.core.indexgenerator.IndexGeneratorImpl;
import cc.redberry.core.indexmapping.IndexMapping;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.iterator.TByteObjectIterator;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;

public final class ApplyIndexMapping {
    public static Tensor renameDummy(Tensor tensor, int[] forbiddenNames, int[] allowedDummiesNames) {
        if (forbiddenNames.length == 0) {
            return tensor;
        }
        if (tensor instanceof Complex || tensor instanceof ScalarFunction) {
            return tensor;
        }
        TIntHashSet allIndicesNames = TensorUtils.getAllDummyIndicesT(tensor);
        if (allIndicesNames.isEmpty()) {
            return tensor;
        }
        allIndicesNames.ensureCapacity(forbiddenNames.length);
        IntArrayList fromL = null;
        for (int forbidden : forbiddenNames) {
            if (allIndicesNames.add(forbidden)) continue;
            if (fromL == null) {
                fromL = new IntArrayList();
            }
            fromL.add(forbidden);
        }
        if (fromL == null) {
            return tensor;
        }
        allIndicesNames.addAll(IndicesUtils.getIndicesNames(tensor.getIndices().getFree()));
        int[] from = fromL.toArray();
        int[] to = new int[fromL.size()];
        Arrays.sort(from);
        IndexGeneratorFromData generator = new IndexGeneratorFromData(allowedDummiesNames);
        for (int i = from.length - 1; i >= 0; --i) {
            to[i] = generator.generate(IndicesUtils.getType(from[i]));
        }
        return ApplyIndexMapping.applyIndexMapping(tensor, new IndexMapper(from, to), false);
    }

    public static Tensor renameDummy(Tensor tensor, int[] forbiddenNames, TIntHashSet added) {
        if (forbiddenNames.length == 0) {
            return tensor;
        }
        if (tensor instanceof Complex || tensor instanceof ScalarFunction) {
            return tensor;
        }
        TIntHashSet allIndicesNames = TensorUtils.getAllDummyIndicesT(tensor);
        if (allIndicesNames.isEmpty()) {
            return tensor;
        }
        allIndicesNames.ensureCapacity(forbiddenNames.length);
        IntArrayList fromL = null;
        for (int forbidden : forbiddenNames) {
            if (allIndicesNames.add(forbidden)) continue;
            if (fromL == null) {
                fromL = new IntArrayList();
            }
            fromL.add(forbidden);
        }
        if (fromL == null) {
            return tensor;
        }
        allIndicesNames.addAll(IndicesUtils.getIndicesNames(tensor.getIndices().getFree()));
        IndexGeneratorImpl generator = new IndexGeneratorImpl(allIndicesNames.toArray());
        int[] from = fromL.toArray();
        int[] to = new int[fromL.size()];
        Arrays.sort(from);
        added.ensureCapacity(from.length);
        for (int i = from.length - 1; i >= 0; --i) {
            to[i] = generator.generate(IndicesUtils.getType(from[i]));
            added.add(to[i]);
        }
        return ApplyIndexMapping.applyIndexMapping(tensor, new IndexMapper(from, to), false);
    }

    public static Tensor renameDummy(Tensor tensor, int[] forbiddenNames) {
        if (forbiddenNames.length == 0) {
            return tensor;
        }
        if (tensor instanceof Complex || tensor instanceof ScalarFunction) {
            return tensor;
        }
        TIntHashSet allIndicesNames = TensorUtils.getAllDummyIndicesT(tensor);
        if (allIndicesNames.isEmpty()) {
            return tensor;
        }
        allIndicesNames.ensureCapacity(forbiddenNames.length);
        IntArrayList fromL = null;
        for (int forbidden : forbiddenNames) {
            if (allIndicesNames.add(forbidden)) continue;
            if (fromL == null) {
                fromL = new IntArrayList();
            }
            fromL.add(forbidden);
        }
        if (fromL == null) {
            return tensor;
        }
        allIndicesNames.addAll(IndicesUtils.getIndicesNames(tensor.getIndices().getFree()));
        IndexGeneratorImpl generator = new IndexGeneratorImpl(allIndicesNames.toArray());
        int[] from = fromL.toArray();
        int[] to = new int[fromL.size()];
        Arrays.sort(from);
        for (int i = from.length - 1; i >= 0; --i) {
            to[i] = generator.generate(IndicesUtils.getType(from[i]));
        }
        return ApplyIndexMapping.applyIndexMapping(tensor, new IndexMapper(from, to), false);
    }

    public static Tensor optimizeDummies(Tensor t) {
        if (t instanceof SimpleTensor || t instanceof ScalarFunction) {
            return t;
        }
        if (t instanceof Sum || t instanceof Expression) {
            Tensor[] oldData = t instanceof Sum ? ((Sum)t).data : t.toArray();
            Tensor[] newData = null;
            DummiesContainer[] dummies = new DummiesContainer[t.size()];
            TByteObjectHashMap maxTypeCounts = new TByteObjectHashMap();
            for (int i = oldData.length - 1; i >= 0; --i) {
                Tensor c = ApplyIndexMapping.optimizeDummies(oldData[i]);
                if (c != oldData[i]) {
                    if (newData == null) {
                        newData = (Tensor[])oldData.clone();
                    }
                    newData[i] = c;
                }
                dummies[i] = new DummiesContainer(TensorUtils.getAllDummyIndicesT(c));
                dummies[i].update(i, (TByteObjectHashMap<MaxType>)maxTypeCounts);
            }
            int totalDummiesCount = 0;
            for (MaxType type : maxTypeCounts.valueCollection()) {
                totalDummiesCount += type.count;
            }
            int[] totalDummies = new int[totalDummiesCount];
            int p = 0;
            TByteObjectIterator maxTypeIterator = maxTypeCounts.iterator();
            while (maxTypeIterator.hasNext()) {
                maxTypeIterator.advance();
                MaxType maxType = (MaxType)maxTypeIterator.value();
                dummies[maxType.pointer].write(maxTypeIterator.key(), p, maxType.count, totalDummies);
                p += maxType.count;
            }
            MasterDummiesContainer masterDummies = new MasterDummiesContainer(totalDummies);
            int[] from = new int[totalDummiesCount];
            int[] to = new int[totalDummiesCount];
            for (int i = oldData.length - 1; i >= 0; --i) {
                int current;
                if (dummies[i].dummies.length == 0) continue;
                int typeStartInFrom = 0;
                int count = 0;
                byte previousType = IndicesUtils.getType(dummies[i].dummies[0]);
                int start = current = masterDummies.typeStart(previousType, 0);
                for (int j = 0; j < dummies[i].dummies.length; ++j) {
                    int index = dummies[i].dummies[j];
                    byte type = IndicesUtils.getType(index);
                    if (previousType != type) {
                        for (int k = count - 1; k >= typeStartInFrom; --k) {
                            to[k] = masterDummies.nextAndRemove(start);
                            assert (IndicesUtils.getType(to[k]) == IndicesUtils.getType(from[k]) && IndicesUtils.getType(from[k]) == previousType);
                        }
                        previousType = type;
                        start = masterDummies.typeStart(type, start);
                        typeStartInFrom = count;
                    }
                    if ((current = masterDummies.remove(index, current)) >= 0) continue;
                    current = ApplyIndexMapping.binarySearchAbs(current);
                    from[count++] = index;
                }
                for (int k = count - 1; k >= typeStartInFrom; --k) {
                    to[k] = masterDummies.nextAndRemove(start);
                    assert (IndicesUtils.getType(to[k]) == IndicesUtils.getType(from[k]) && IndicesUtils.getType(from[k]) == previousType);
                }
                masterDummies.reset();
                if (count == 0) continue;
                if (newData == null) {
                    newData = (Tensor[])oldData.clone();
                }
                newData[i] = ApplyIndexMapping.applyIndexMapping(newData[i], new IndexMapper(from, to, count), false);
            }
            if (newData == null) {
                return t;
            }
            return t instanceof Sum ? new Sum(newData, t.getIndices()) : new Expression(t.getIndices(), newData[0], newData[1]);
        }
        return ApplyIndexMapping.__unsafe_mapping_apply__(t, new Transformation(){

            @Override
            public Tensor transform(Tensor t) {
                return ApplyIndexMapping.optimizeDummies(t);
            }
        });
    }

    private static int binarySearchAbs(int i) {
        return i < 0 ? ~i : i;
    }

    private static Tensor renameDummyWithSign(Tensor tensor, int[] forbidden, boolean sign) {
        Tensor result = ApplyIndexMapping.renameDummy(tensor, forbidden);
        return sign ? Tensors.negate(result) : result;
    }

    public static Tensor applyIndexMappingAutomatically(Tensor tensor, Mapping mapping) {
        return ApplyIndexMapping.applyIndexMappingAutomatically(tensor, mapping, new int[0]);
    }

    public static Tensor applyIndexMappingAutomatically(Tensor tensor, Mapping mapping, int[] forbidden) {
        int i;
        if (mapping.isEmpty() || tensor.getIndices().getFree().size() == 0) {
            return ApplyIndexMapping.renameDummyWithSign(tensor, forbidden, mapping.getSign());
        }
        int[] freeIndices = IndicesUtils.getIndicesNames(tensor.getIndices().getFree());
        Arrays.sort(freeIndices);
        int[] from = mapping.getFromNames().copy();
        int[] to = mapping.getToData().copy();
        int pointer = 0;
        int oldFromLength = from.length;
        for (i = 0; i < oldFromLength; ++i) {
            if (Arrays.binarySearch(freeIndices, from[i]) < 0) continue;
            from[pointer] = from[i];
            to[pointer] = to[i];
            ++pointer;
        }
        if (pointer == 0) {
            return ApplyIndexMapping.renameDummyWithSign(tensor, forbidden, mapping.getSign());
        }
        int newFromLength = pointer;
        ArraysUtils.quickSort(from, 0, pointer, to);
        IntArrayList list = new IntArrayList();
        for (i = 0; i < freeIndices.length; ++i) {
            if (Arrays.binarySearch(from, 0, pointer, freeIndices[i]) >= 0) continue;
            if (newFromLength < oldFromLength) {
                from[newFromLength] = to[newFromLength] = freeIndices[i];
            } else {
                list.add(freeIndices[i]);
            }
            ++newFromLength;
        }
        if (newFromLength < oldFromLength) {
            from = Arrays.copyOfRange(from, 0, newFromLength);
            to = Arrays.copyOfRange(to, 0, newFromLength);
        } else if (newFromLength > oldFromLength) {
            int[] toAdd = list.toArray();
            from = Arrays.copyOfRange(from, 0, newFromLength);
            to = Arrays.copyOfRange(to, 0, newFromLength);
            System.arraycopy(toAdd, 0, from, oldFromLength, toAdd.length);
            System.arraycopy(toAdd, 0, to, oldFromLength, toAdd.length);
        }
        assert (from.length == freeIndices.length);
        return ApplyIndexMapping.applyIndexMapping(tensor, new Mapping(from, to, mapping.getSign()), forbidden);
    }

    public static Tensor applyIndexMapping(Tensor tensor, Mapping mapping) {
        return ApplyIndexMapping.applyIndexMapping(tensor, mapping, new int[0]);
    }

    public static Tensor applyIndexMapping(Tensor tensor, Mapping mapping, int[] forbidden) {
        if (mapping.isEmpty()) {
            if (tensor.getIndices().getFree().size() != 0) {
                throw new IllegalArgumentException("From length does not match free indices size.");
            }
            return ApplyIndexMapping.renameDummyWithSign(tensor, forbidden, mapping.getSign());
        }
        int[] freeIndicesNames = IndicesUtils.getIndicesNames(tensor.getIndices().getFree());
        Arrays.sort(freeIndicesNames);
        if (!mapping.getFromNames().equalsToArray(freeIndicesNames)) {
            throw new IllegalArgumentException("From indices names does not match free indices names of tensor.");
        }
        Tensor result = ApplyIndexMapping._applyIndexMapping(tensor, mapping, forbidden);
        return mapping.getSign() ? Tensors.negate(result) : result;
    }

    private static Tensor _applyIndexMapping(Tensor tensor, Mapping mapping, int[] forbidden) {
        int mappingSize = mapping.size();
        int[] allForbidden = new int[mappingSize + forbidden.length];
        IntArray toData = mapping.getToData();
        IntArray fromNames = mapping.getFromNames();
        ArraysUtils.arraycopy(toData, 0, allForbidden, 0, mappingSize);
        System.arraycopy(forbidden, 0, allForbidden, mappingSize, forbidden.length);
        for (int i = allForbidden.length - 1; i >= 0; --i) {
            allForbidden[i] = IndicesUtils.getNameWithType(allForbidden[i]);
        }
        IntArrayList fromL = new IntArrayList(mappingSize);
        IntArrayList toL = new IntArrayList(mappingSize);
        fromL.addAll(fromNames);
        toL.addAll(toData);
        Arrays.sort(allForbidden);
        int[] dummyIndices = TensorUtils.getAllDummyIndicesT(tensor).toArray();
        int[] forbiddenGeneratorIndices = new int[allForbidden.length + dummyIndices.length];
        System.arraycopy(allForbidden, 0, forbiddenGeneratorIndices, 0, allForbidden.length);
        System.arraycopy(dummyIndices, 0, forbiddenGeneratorIndices, allForbidden.length, dummyIndices.length);
        IndexGeneratorImpl generator = new IndexGeneratorImpl(forbiddenGeneratorIndices);
        for (int index : dummyIndices) {
            if (Arrays.binarySearch(allForbidden, index) < 0) continue;
            assert (ArraysUtils.binarySearch(fromNames, index) < 0);
            fromL.add(index);
            toL.add(generator.generate(IndicesUtils.getType(index)));
        }
        int[] _from = fromL.toArray();
        int[] _to = toL.toArray();
        ArraysUtils.quickSort(_from, _to);
        return ApplyIndexMapping.applyIndexMapping(tensor, new IndexMapper(_from, _to));
    }

    private static Tensor applyIndexMapping(Tensor tensor, IndexMapper indexMapper) {
        if (tensor instanceof SimpleTensor) {
            return ApplyIndexMapping.applyIndexMapping(tensor, indexMapper, false);
        }
        if (tensor instanceof Complex || tensor instanceof ScalarFunction) {
            return tensor;
        }
        return ApplyIndexMapping.applyIndexMapping(tensor, indexMapper, indexMapper.contract(IndicesUtils.getIndicesNames(tensor.getIndices().getFree())));
    }

    public static Tensor applyIndexMappingAndRenameAllDummies(Tensor tensor, Mapping mapping, int[] allowedDummies) {
        int[] freeIndicesNames = IndicesUtils.getIndicesNames(tensor.getIndices().getFree());
        Arrays.sort(freeIndicesNames);
        if (!mapping.getFromNames().equalsToArray(freeIndicesNames)) {
            throw new IllegalArgumentException("From indices names does not match free indices names of tensor.");
        }
        int[] dummies = TensorUtils.getAllDummyIndicesT(tensor).toArray();
        int[] from = new int[mapping.size() + dummies.length];
        int[] to = new int[mapping.size() + dummies.length];
        ArraysUtils.arraycopy(mapping.getFromNames(), 0, from, 0, mapping.size());
        ArraysUtils.arraycopy(mapping.getToData(), 0, to, 0, mapping.size());
        System.arraycopy(dummies, 0, from, mapping.size(), dummies.length);
        IndexGeneratorFromData generator = new IndexGeneratorFromData(allowedDummies);
        int mappingSize = mapping.size();
        for (int i = mapping.size() + dummies.length - 1; i >= mappingSize; --i) {
            to[i] = generator.generate(IndicesUtils.getType(from[i]));
        }
        ArraysUtils.quickSort(from, to);
        tensor = ApplyIndexMapping.applyIndexMapping(tensor, new IndexMapper(from, to));
        if (mapping.getSign()) {
            tensor = Tensors.negate(tensor);
        }
        return tensor;
    }

    private static Tensor applyIndexMapping(Tensor tensor, final IndexMapper indexMapper, boolean contractIndices) {
        if (tensor instanceof SimpleTensor) {
            SimpleIndices newIndices;
            SimpleTensor simpleTensor = (SimpleTensor)tensor;
            SimpleIndices oldIndices = simpleTensor.getIndices();
            if (oldIndices == (newIndices = oldIndices.applyIndexMapping(indexMapper))) {
                return tensor;
            }
            if (tensor instanceof TensorField) {
                TensorField field = (TensorField)simpleTensor;
                return Tensors.field(field.name, newIndices, field.argIndices, field.args);
            }
            return Tensors.simpleTensor(simpleTensor.name, newIndices);
        }
        if (tensor instanceof Complex || tensor instanceof ScalarFunction) {
            return tensor;
        }
        if (tensor instanceof Expression) {
            boolean contract = indexMapper.contract(IndicesUtils.getIndicesNames(tensor.getIndices()));
            Tensor newLhs = ApplyIndexMapping.applyIndexMapping(tensor.get(0), indexMapper, contract);
            Tensor newRhs = ApplyIndexMapping.applyIndexMapping(tensor.get(1), indexMapper, contract);
            if (newLhs != tensor.get(0) || newRhs != tensor.get(1)) {
                return Tensors.expression(newLhs, newRhs);
            }
            return tensor;
        }
        if (tensor instanceof Power) {
            Tensor newBase;
            Tensor oldBase = tensor.get(0);
            if (oldBase == (newBase = ApplyIndexMapping.applyIndexMapping(oldBase, indexMapper, false))) {
                return tensor;
            }
            return new Power(newBase, tensor.get(1));
        }
        if (contractIndices) {
            return Transformation.Util.applyToEachChild(tensor, new Transformation(){

                @Override
                public Tensor transform(Tensor tt) {
                    return ApplyIndexMapping.applyIndexMapping(tt, indexMapper);
                }
            });
        }
        if (tensor instanceof Product) {
            Tensor newTensor;
            Tensor oldTensor;
            int i;
            Product product = (Product)tensor;
            Tensor[] indexless = product.getIndexless();
            Tensor[] newIndexless = null;
            Tensor[] data = product.data;
            Tensor[] newData = null;
            for (i = indexless.length - 1; i >= 0; --i) {
                oldTensor = indexless[i];
                newTensor = ApplyIndexMapping.applyIndexMapping(oldTensor, indexMapper, false);
                if (oldTensor == newTensor) continue;
                if (newIndexless == null) {
                    newIndexless = (Tensor[])indexless.clone();
                }
                newIndexless[i] = newTensor;
            }
            for (i = data.length - 1; i >= 0; --i) {
                oldTensor = data[i];
                newTensor = ApplyIndexMapping.applyIndexMapping(oldTensor, indexMapper, false);
                if (oldTensor == newTensor) continue;
                if (newData == null) {
                    newData = (Tensor[])data.clone();
                }
                newData[i] = newTensor;
            }
            if (newIndexless == null && newData == null) {
                return tensor;
            }
            if (newIndexless == null) {
                newIndexless = indexless;
            }
            if (newData == null) {
                return new Product(product.indices, product.factor, newIndexless, data, product.contentReference);
            }
            return new Product(new IndicesBuilder().append(newData).getIndices(), product.factor, newIndexless, newData);
        }
        if (tensor instanceof Sum) {
            Sum sum = (Sum)tensor;
            Tensor[] data = sum.data;
            Tensor[] newData = null;
            for (int i = data.length - 1; i >= 0; --i) {
                Tensor oldTensor = data[i];
                Tensor newTensor = ApplyIndexMapping.applyIndexMapping(oldTensor, indexMapper, false);
                if (oldTensor == newTensor) continue;
                if (newData == null) {
                    newData = (Tensor[])data.clone();
                }
                newData[i] = newTensor;
            }
            if (newData == null) {
                return tensor;
            }
            return new Sum(newData, IndicesFactory.create(newData[0].getIndices().getFree()));
        }
        throw new RuntimeException();
    }

    private static Tensor __unsafe_mapping_apply__(Tensor tensor, Transformation mapping) {
        if (tensor instanceof SimpleTensor) {
            Tensor newTensor = mapping.transform(tensor);
            if (newTensor != tensor) {
                return newTensor;
            }
            return tensor;
        }
        if (tensor instanceof Complex || tensor instanceof ScalarFunction) {
            return tensor;
        }
        if (tensor instanceof Expression) {
            Tensor newLhs = mapping.transform(tensor.get(0));
            Tensor newRhs = mapping.transform(tensor.get(1));
            if (newLhs == tensor.get(0) && newRhs == tensor.get(1)) {
                return tensor;
            }
            return Tensors.expression(newLhs, newRhs);
        }
        if (tensor instanceof Power) {
            Tensor newBase;
            Tensor oldBase = tensor.get(0);
            if (oldBase == (newBase = mapping.transform(oldBase))) {
                return tensor;
            }
            return new Power(newBase, tensor.get(1));
        }
        if (tensor instanceof Product) {
            Tensor newTensor;
            Tensor oldTensor;
            int i;
            Product product = (Product)tensor;
            Tensor[] indexless = product.getIndexless();
            Tensor[] newIndexless = null;
            Tensor[] data = product.data;
            Tensor[] newData = null;
            for (i = indexless.length - 1; i >= 0; --i) {
                oldTensor = indexless[i];
                newTensor = mapping.transform(oldTensor);
                if (oldTensor == newTensor) continue;
                if (newIndexless == null) {
                    newIndexless = (Tensor[])indexless.clone();
                }
                newIndexless[i] = newTensor;
            }
            for (i = data.length - 1; i >= 0; --i) {
                oldTensor = data[i];
                newTensor = mapping.transform(oldTensor);
                if (oldTensor == newTensor) continue;
                if (newData == null) {
                    newData = (Tensor[])data.clone();
                }
                newData[i] = newTensor;
            }
            if (newIndexless == null && newData == null) {
                return tensor;
            }
            if (newIndexless == null) {
                newIndexless = indexless;
            }
            if (newData == null) {
                return new Product(product.indices, product.factor, newIndexless, data, product.contentReference);
            }
            return new Product(new IndicesBuilder().append(newData).getIndices(), product.factor, newIndexless, newData);
        }
        if (tensor instanceof Sum) {
            Sum sum = (Sum)tensor;
            Tensor[] data = sum.data;
            Tensor[] newData = null;
            for (int i = data.length - 1; i >= 0; --i) {
                Tensor oldTensor = data[i];
                Tensor newTensor = mapping.transform(oldTensor);
                if (oldTensor == newTensor) continue;
                if (newData == null) {
                    newData = (Tensor[])data.clone();
                }
                newData[i] = newTensor;
            }
            if (newData == null) {
                return tensor;
            }
            return new Sum(newData, IndicesFactory.create(newData[0].getIndices().getFree()));
        }
        throw new RuntimeException();
    }

    public static Tensor renameIndicesOfFieldsArguments(Tensor tensor, TIntSet forbidden) {
        if (tensor instanceof TensorField) {
            TensorField field = (TensorField)tensor;
            Tensor[] args = null;
            SimpleIndices[] argsIndices = null;
            int[] _forbidden = forbidden.toArray();
            for (int i = field.size() - 1; i >= 0; --i) {
                Tensor arg = field.args[i];
                int[] _from = TensorUtils.getAllIndicesNamesT(arg).toArray();
                IndexGeneratorImpl ig = new IndexGeneratorImpl(ArraysUtils.addAll(_forbidden, _from));
                Arrays.sort(_from);
                int[] _to = new int[_from.length];
                for (int j = _from.length - 1; j >= 0; --j) {
                    _to[j] = forbidden.contains(_from[j]) ? ig.generate(IndicesUtils.getType(_from[j])) : _from[j];
                    forbidden.add(_to[j]);
                }
                IndexMapper mapping = new IndexMapper(_from, _to);
                if ((arg = ApplyIndexMapping.applyIndexMapping(arg, mapping)) == field.args[i]) continue;
                if (args == null) {
                    args = (Tensor[])field.args.clone();
                    argsIndices = (SimpleIndices[])field.argIndices.clone();
                }
                args[i] = arg;
                argsIndices[i] = field.argIndices[i].applyIndexMapping(mapping);
            }
            if (args == null) {
                return tensor;
            }
            return Tensors.field(field.name, field.indices, argsIndices, args);
        }
        if (tensor instanceof Product) {
            Tensor temp;
            int i;
            Product p = (Product)tensor;
            Tensor[] data = null;
            Tensor[] indexless = null;
            for (i = p.data.length - 1; i >= 0; --i) {
                temp = ApplyIndexMapping.renameIndicesOfFieldsArguments(p.data[i], forbidden);
                if (temp == p.data[i]) continue;
                if (data == null) {
                    data = (Tensor[])p.data.clone();
                }
                data[i] = temp;
            }
            for (i = p.indexlessData.length - 1; i >= 0; --i) {
                temp = ApplyIndexMapping.renameIndicesOfFieldsArguments(p.indexlessData[i], forbidden);
                if (temp == p.indexlessData[i]) continue;
                if (indexless == null) {
                    indexless = (Tensor[])p.indexlessData.clone();
                }
                indexless[i] = temp;
            }
            if (data == null && indexless == null) {
                return tensor;
            }
            if (data == null) {
                data = p.data;
            }
            if (indexless == null) {
                indexless = p.indexlessData;
            }
            return new Product(p.indices, p.factor, indexless, data, p.contentReference, p.hash);
        }
        if (tensor instanceof Sum) {
            Sum s = (Sum)tensor;
            Tensor[] data = null;
            for (int i = s.size() - 1; i >= 0; --i) {
                Tensor temp = ApplyIndexMapping.renameIndicesOfFieldsArguments(s.data[i], forbidden);
                if (temp == s.data[i]) continue;
                if (data == null) {
                    data = (Tensor[])s.data.clone();
                }
                data[i] = temp;
            }
            if (data == null) {
                return tensor;
            }
            return new Sum(s.indices, data, s.hash);
        }
        if (tensor instanceof Complex || tensor instanceof SimpleTensor) {
            return tensor;
        }
        if (tensor instanceof Power || tensor instanceof Expression) {
            Tensor a = ApplyIndexMapping.renameIndicesOfFieldsArguments(tensor.get(0), forbidden);
            Tensor b = ApplyIndexMapping.renameIndicesOfFieldsArguments(tensor.get(1), forbidden);
            if (a == tensor.get(0) && b == tensor.get(1)) {
                return tensor;
            }
            return tensor.getFactory().create(a, b);
        }
        if (tensor instanceof ScalarFunction) {
            Tensor arg = ApplyIndexMapping.renameIndicesOfFieldsArguments(tensor.get(0), forbidden);
            if (arg == tensor.get(0)) {
                return tensor;
            }
            return tensor.getFactory().create(arg);
        }
        throw new RuntimeException();
    }

    private static void checkConsistent(Tensor tensor, int[] from) {
        int[] freeIndices = tensor.getIndices().getFree().getAllIndices().copy();
        Arrays.sort(freeIndices);
        if (!Arrays.equals(freeIndices, from)) {
            throw new IllegalArgumentException("From indices are not equal to free indices of tensor.");
        }
    }

    private static final class IndexMapper
    implements IndexMapping {
        private final int[] from;
        private final int[] to;
        private final int size;

        private IndexMapper(int[] from, int[] to, int size) {
            this.from = from;
            this.to = to;
            this.size = size;
        }

        public IndexMapper(int[] from, int[] to) {
            this(from, to, from.length);
        }

        @Override
        public int map(int index) {
            int position = Arrays.binarySearch(this.from, 0, this.size, IndicesUtils.getNameWithType(index));
            if (position < 0) {
                return index;
            }
            return IndicesUtils.getRawStateInt(index) ^ this.to[position];
        }

        boolean contract(int[] freeIndicesNames) {
            int i;
            if (freeIndicesNames.length <= 1) {
                return false;
            }
            for (i = 0; i < freeIndicesNames.length; ++i) {
                freeIndicesNames[i] = Integer.MAX_VALUE & this.map(freeIndicesNames[i]);
            }
            Arrays.sort(freeIndicesNames);
            for (i = 1; i < freeIndicesNames.length; ++i) {
                if (freeIndicesNames[i] != freeIndicesNames[i - 1]) continue;
                return true;
            }
            return false;
        }
    }

    static final class DummiesContainer {
        final int[] dummies;

        DummiesContainer(TIntHashSet dummiesT) {
            this.dummies = dummiesT.toArray();
            Arrays.sort(this.dummies);
        }

        void update(int pointer, TByteObjectHashMap<MaxType> maxTypeValues) {
            int previousPointer = 0;
            while (previousPointer < this.dummies.length) {
                byte type = IndicesUtils.getType(this.dummies[previousPointer]);
                int current = ApplyIndexMapping.binarySearchAbs(Arrays.binarySearch(this.dummies, previousPointer, this.dummies.length, type + 1 << 24));
                int count = current - previousPointer;
                MaxType typeInfo = (MaxType)maxTypeValues.get(type);
                if (typeInfo == null) {
                    maxTypeValues.put(type, (Object)new MaxType(count, pointer));
                } else if (typeInfo.count < count) {
                    typeInfo.count = count;
                    typeInfo.pointer = pointer;
                }
                previousPointer = current;
            }
        }

        void write(byte type, int start, int count, int[] dest) {
            int startPointer = ApplyIndexMapping.binarySearchAbs(Arrays.binarySearch(this.dummies, 0, this.dummies.length, type << 24));
            assert (count == ApplyIndexMapping.binarySearchAbs(Arrays.binarySearch(this.dummies, startPointer, this.dummies.length, type + 1 << 24)) - startPointer);
            System.arraycopy(this.dummies, startPointer, dest, start, count);
        }
    }

    static final class MasterDummiesContainer {
        final int[] totalDummies;
        final BitArray removed;

        MasterDummiesContainer(int[] totalDummies) {
            this.totalDummies = totalDummies;
            Arrays.sort(this.totalDummies);
            this.removed = new BitArray(totalDummies.length);
        }

        void reset() {
            this.removed.clearAll();
        }

        int remove(int index, int start) {
            int r = Arrays.binarySearch(this.totalDummies, start, this.totalDummies.length, index);
            if (r >= 0) {
                this.removed.set(r);
            }
            return r;
        }

        int typeStart(byte type, int from) {
            return ApplyIndexMapping.binarySearchAbs(Arrays.binarySearch(this.totalDummies, from, this.totalDummies.length, type << 24));
        }

        int nextAndRemove(int start) {
            int pointer = this.removed.nextZeroBit(start);
            this.removed.set(pointer);
            return this.totalDummies[pointer];
        }
    }

    static final class MaxType {
        int count;
        int pointer;

        MaxType(int count, int pointer) {
            this.count = count;
            this.pointer = pointer;
        }
    }
}

