/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.solver;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.number.Complex;
import cc.redberry.core.solver.ReducedSystem;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.TransformationCollection;
import cc.redberry.core.transformations.substitutions.SubstitutionTransformation;
import cc.redberry.core.utils.THashMap;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;

public class ExternalSolver {
    public static Expression[][] solveSystemWithMaple(ReducedSystem reducedSystem, boolean keepFreeParameters, String mapleBinDir, String path) throws IOException, InterruptedException {
        return ExternalSolver.solveSystemWithExternalProgram(MapleScriptCreator.INSTANCE, reducedSystem, keepFreeParameters, mapleBinDir, path);
    }

    public static Expression[][] solveSystemWithMathematica(ReducedSystem reducedSystem, boolean keepFreeParameters, String mathematicaBinDir, String path) throws IOException, InterruptedException {
        return ExternalSolver.solveSystemWithExternalProgram(MathematicaScriptCreator.INSTANCE, reducedSystem, keepFreeParameters, mathematicaBinDir, path);
    }

    /*
     * WARNING - void declaration
     */
    public static Expression[][] solveSystemWithExternalProgram(ExternalScriptCreator scriptCreator, ReducedSystem reducedSystem, boolean keepFreeParameters, String programBinDir, String path) throws IOException, InterruptedException {
        String strLine;
        int i;
        Expression[] equations = (Expression[])reducedSystem.equations.clone();
        THashMap<Tensor, SimpleTensor> tensorSubstitutions = new THashMap<Tensor, SimpleTensor>();
        for (i = 0; i < equations.length; ++i) {
            Tensor tensor;
            Expression eq = equations[i];
            FromChildToParentIterator iterator = new FromChildToParentIterator(eq);
            while ((tensor = iterator.next()) != null) {
                Tensor[] scalars;
                if (!(tensor instanceof Product) || tensor.getIndices().size() == 0) continue;
                for (Tensor scalar : scalars = ((Product)tensor).getContent().getScalars()) {
                    if (tensorSubstitutions.containsKey(scalar)) continue;
                    tensorSubstitutions.put(scalar, CC.generateNewSymbol());
                }
            }
        }
        Expression[] scalarSubs = new Expression[tensorSubstitutions.size()];
        i = -1;
        for (Map.Entry entry : tensorSubstitutions.entrySet()) {
            scalarSubs[++i] = Tensors.expression((Tensor)entry.getKey(), (Tensor)entry.getValue());
        }
        SubstitutionTransformation fullSub = new SubstitutionTransformation(scalarSubs, true);
        for (i = 0; i < equations.length; ++i) {
            equations[i] = (Expression)fullSub.transform(equations[i]);
        }
        scriptCreator.createScript(equations, reducedSystem, path, keepFreeParameters);
        new File(path + "/equations." + scriptCreator.getScriptExtension() + "Out").delete();
        try {
            String line;
            String[] stringArray = scriptCreator.getParameters();
            String[] exec = new String[2 + stringArray.length];
            exec[0] = programBinDir + "/" + scriptCreator.getScriptExecutionCommand();
            for (i = 0; i < stringArray.length; ++i) {
                exec[i + 1] = stringArray[i];
            }
            exec[exec.length - 1] = path + "/equations." + scriptCreator.getScriptExtension();
            Process p = Runtime.getRuntime().exec(exec);
            BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = bri.readLine()) != null) {
                System.out.println(line);
            }
            bri.close();
            while ((line = bre.readLine()) != null) {
                System.out.println(line);
            }
            bre.close();
            p.waitFor();
        }
        catch (IOException | InterruptedException exception) {
            throw new RuntimeException(exception);
        }
        Expression[] expressionArray = new Expression[reducedSystem.unknownCoefficients.length];
        if (!new File(path + "/equations." + scriptCreator.getScriptExtension() + "Out").exists()) {
            return new Expression[0][];
        }
        FileInputStream fstream = new FileInputStream(path + "/equations." + scriptCreator.getScriptExtension() + "Out");
        if (fstream.available() == 0) {
            return null;
        }
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        i = -1;
        ArrayList<Expression[]> solutions = new ArrayList<Expression[]>();
        while ((strLine = br.readLine()) != null) {
            if (strLine.equals("//solution")) {
                int si;
                void var10_16;
                Expression[] solution = (Expression[])reducedSystem.generalSolutions.clone();
                ArrayList<Transformation> zeroSubs = new ArrayList<Transformation>();
                for (void coef : var10_16) {
                    if (coef.isIdentity() && !keepFreeParameters) {
                        zeroSubs.add(Tensors.expression(coef.get(0), Complex.ZERO));
                        continue;
                    }
                    for (si = solution.length - 1; si >= 0; --si) {
                        solution[si] = (Expression)coef.transform(solution[si]);
                    }
                }
                if (!keepFreeParameters) {
                    for (int si2 = solution.length - 1; si2 >= 0; --si2) {
                        solution[si2] = (Expression)new TransformationCollection(zeroSubs).transform(solution[si2]);
                    }
                }
                for (Expression sub : scalarSubs) {
                    for (si = solution.length - 1; si >= 0; --si) {
                        solution[si] = (Expression)sub.transpose().transform(solution[si]);
                    }
                }
                solutions.add(solution);
                Expression[] expressionArray2 = new Expression[reducedSystem.unknownCoefficients.length];
                i = -1;
                continue;
            }
            var10_16[++i] = Tensors.parseExpression(strLine);
        }
        in.close();
        return (Expression[][])solutions.toArray((T[])new Expression[solutions.size()][]);
    }

    public static final class MapleScriptCreator
    implements ExternalScriptCreator {
        public static final MapleScriptCreator INSTANCE = new MapleScriptCreator();

        private MapleScriptCreator() {
        }

        @Override
        public void createScript(Expression[] equations, ReducedSystem reducedSystem, String path, boolean keepFreeParams) throws IOException {
            int i;
            FileOutputStream output = new FileOutputStream(path + "/equations.maple");
            PrintStream file = new PrintStream(output);
            file.append("with(StringTools):\n");
            file.append("ans:=array([");
            for (i = 0; i < reducedSystem.unknownCoefficients.length; ++i) {
                if (i == reducedSystem.unknownCoefficients.length - 1) {
                    file.append(reducedSystem.unknownCoefficients[i].toString(OutputFormat.Maple));
                    continue;
                }
                file.append(reducedSystem.unknownCoefficients[i].toString(OutputFormat.Maple) + ",");
            }
            file.append("]):\n");
            file.println("eq:=array(1.." + equations.length + "):");
            for (i = 0; i < equations.length; ++i) {
                file.println("eq[" + (i + 1) + "]:=" + equations[i].toString(OutputFormat.Maple) + ":");
            }
            file.print("Result := solve(simplify({seq(eq[i],i=1.." + equations.length + ")}),[");
            for (i = 0; i < reducedSystem.unknownCoefficients.length; ++i) {
                if (i == reducedSystem.unknownCoefficients.length - 1) {
                    file.append(reducedSystem.unknownCoefficients[i].toString(OutputFormat.Maple));
                    continue;
                }
                file.append(reducedSystem.unknownCoefficients[i].toString(OutputFormat.Maple) + ",");
            }
            file.append("],explicit=true):\n");
            file.append("if nops(Result) <> 0 then\n");
            file.append("Result:= factor(Result);\n");
            file.println("file:=fopen(\"" + path + "/equations.mapleOut\",WRITE):");
            file.append("for maple_positionInResult from 1 to nops(Result) do\n");
            file.append("for maple_counter from 1 to " + reducedSystem.unknownCoefficients.length + " do\n");
            file.append("temp1 := SubstituteAll(convert(lhs(Result[maple_positionInResult][maple_counter]), string), \"^\", \"**\");\n");
            file.append("temp1 := SubstituteAll(convert(lhs(Result[maple_positionInResult][maple_counter]), string), \"(\", \"[\");\n");
            file.append("temp1 := SubstituteAll(convert(lhs(Result[maple_positionInResult][maple_counter]), string), \")\", \"]\");\n");
            file.append("temp2 := SubstituteAll(convert(rhs(Result[maple_positionInResult][maple_counter]), string), \"^\", \"**\");\n");
            file.append("fprintf(file,\"%s=%s\\n\",temp1,temp2);\n");
            file.append("od:\n");
            file.append("fprintf(file,\"//solution\\n\");\n");
            file.append("od:\n");
            file.append("end if;\n");
            file.append("fclose(file):");
            output.close();
            file.close();
        }

        @Override
        public String getScriptExecutionCommand() {
            return "maple";
        }

        @Override
        public String getScriptExtension() {
            return "maple";
        }

        @Override
        public String[] getParameters() {
            return new String[0];
        }
    }

    public static final class MathematicaScriptCreator
    implements ExternalScriptCreator {
        public static final MathematicaScriptCreator INSTANCE = new MathematicaScriptCreator();

        private MathematicaScriptCreator() {
        }

        @Override
        public void createScript(Expression[] equations, ReducedSystem reducedSystem, String path, boolean keepFreeParams) throws IOException {
            FileOutputStream output = new FileOutputStream(path + "/equations.mathematica");
            PrintStream file = new PrintStream(output);
            file.append("$equations = {\n");
            int i = 0;
            while (true) {
                file.append(equations[i].toString(OutputFormat.WolframMathematica).replace("=", "=="));
                if (i == equations.length - 1) break;
                file.append(",\n");
                ++i;
            }
            file.append("\n};\n");
            file.append("$coefficients = {");
            i = 0;
            while (true) {
                file.append(reducedSystem.unknownCoefficients[i].toString(OutputFormat.WolframMathematica));
                if (i == reducedSystem.unknownCoefficients.length - 1) break;
                file.append(',');
                ++i;
            }
            file.append(" };\n");
            file.append("$result = Solve[$equations,$coefficients];\n");
            file.append("If[Length[$result] != 0, ");
            file.append("$result = Simplify[$result];\n");
            file.append("$stream = OpenWrite[\"" + path + "/equations.mathematicaOut\"];\n");
            file.append("For[$solution = 1, $solution <= Length[$result], ++$solution, ");
            file.append("$tempResult = $result[[$solution]];");
            file.append("$found = $tempResult[[All, 1]];\n");
            if (!keepFreeParams) {
                file.append("For[$i = 1, $i <= Length[$coefficients], ++$i,If[!MemberQ[$found, $coefficients[[$i]]], $tempResult = $tempResult/.{$coefficients[[$i]] -> 0}; AppendTo[$tempResult, $coefficients[[$i]] -> 0];]];\n");
            } else {
                file.append("For[$i = 1, $i <= Length[$coefficients], ++$i,If[!MemberQ[$found, $coefficients[[$i]]], AppendTo[$tempResult, $coefficients[[$i]] -> $coefficients[[$i]]];]];\n");
            }
            file.append("$tempResult = Simplify[$tempResult];\n");
            file.append("For[$i = 1, $i <= Length[$coefficients], ++$i, WriteString[$stream, StringReplace[ToString[$tempResult[[$i]] // InputForm], {\"->\" -> \"=\", \"^\" -> \"**\"}] <> If[$i != Length[$coefficients], \"\\n\", \"\"]]];\n");
            file.append("WriteString[$stream, \"\n//solution\n\"];");
            file.append("];");
            file.append("Close[$stream];");
            file.append("];");
            output.close();
            file.close();
        }

        @Override
        public String getScriptExecutionCommand() {
            return "MathematicaScript";
        }

        @Override
        public String[] getParameters() {
            return new String[]{"-script"};
        }

        @Override
        public String getScriptExtension() {
            return "mathematica";
        }
    }

    public static interface ExternalScriptCreator {
        public void createScript(Expression[] var1, ReducedSystem var2, String var3, boolean var4) throws IOException;

        public String getScriptExecutionCommand();

        public String getScriptExtension();

        public String[] getParameters();
    }
}

