/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.BracketsError;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenNumber;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.ParseTokenTensorField;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.ParserIndices;
import cc.redberry.core.parser.ParserSimpleTensor;
import cc.redberry.core.parser.TokenParser;
import cc.redberry.core.parser.TokenType;
import java.util.ArrayList;

public class ParserTensorField
implements TokenParser {
    public static final ParserTensorField INSTANCE = new ParserTensorField();

    private ParserTensorField() {
    }

    @Override
    public int priority() {
        return 7000;
    }

    public boolean canParse(String expression) {
        char[] expressionChars = expression.toCharArray();
        int level = 0;
        boolean inBrackets = false;
        for (char c : expressionChars) {
            if (!(c != '+' && c != '*' && c != '-' && c != '/' || inBrackets)) {
                return false;
            }
            if (c == '[') {
                inBrackets = true;
                ++level;
            }
            if (c == ']') {
                --level;
            }
            if (level == 0) {
                inBrackets = false;
            }
            if (level >= 0) continue;
            throw new BracketsError(expression);
        }
        return true;
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (!expression.contains("[")) {
            return null;
        }
        if (!this.canParse(expression)) {
            return null;
        }
        String tensorPart = expression.substring(0, expression.indexOf(91));
        ParseTokenSimpleTensor simpleTensorNode = ParserSimpleTensor.INSTANCE.parseToken(tensorPart, parser);
        String argString = expression.substring(expression.indexOf("[") + 1, expression.length() - 1);
        ArrayList<ParseToken> arguments = new ArrayList<ParseToken>();
        ArrayList<SimpleIndices> indices = new ArrayList<SimpleIndices>();
        int beginIndex = 0;
        int level = 0;
        char[] argsChars = argString.toCharArray();
        for (int i = 0; i < argsChars.length; ++i) {
            char c = argsChars[i];
            if (c == ',' && level == 0 || i == argsChars.length - 1) {
                SimpleIndices aIndices;
                ParseToken a;
                String argument = argString.substring(beginIndex, i == argsChars.length - 1 ? i + 1 : i);
                String[] split = argument.split(":");
                if (split.length == 1) {
                    a = parser.parse(argument);
                    aIndices = null;
                } else {
                    if (split.length != 2) {
                        throw new ParserException(expression);
                    }
                    a = parser.parse(split[0]);
                    aIndices = ParserIndices.parseSimple(split[1]);
                }
                arguments.add(a);
                indices.add(aIndices);
                beginIndex = i + 1;
            }
            if (c == '[') {
                ++level;
            }
            if (c != ']') continue;
            --level;
        }
        if (simpleTensorNode.name.toLowerCase().equals("sqrt") && simpleTensorNode.indices.size() == 0 && arguments.size() == 1 && ((ParseToken)arguments.get(0)).getIndices().getFree().size() == 0) {
            return new ParseToken(TokenType.Power, (ParseToken)arguments.get(0), new ParseTokenNumber(Complex.ONE_HALF));
        }
        return new ParseTokenTensorField(simpleTensorNode.indices, simpleTensorNode.name, arguments.toArray(new ParseToken[arguments.size()]), indices.toArray(new SimpleIndices[indices.size()]));
    }
}

