/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenScalarFunction;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.TokenParser;

public class ParserFunctions
implements TokenParser {
    public static final ParserFunctions INSTANCE = new ParserFunctions();
    private static final String[] functions = new String[]{"Sin", "Cos", "Tan", "Log", "Exp", "Cot", "ArcSin", "ArcCos", "ArcTan", "ArcCot"};

    private ParserFunctions() {
    }

    @Override
    public int priority() {
        return 9987;
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (!expression.contains("[") || expression.lastIndexOf(93) != expression.length() - 1) {
            return null;
        }
        String temp = null;
        String function = null;
        for (int i = 0; i < functions.length; ++i) {
            temp = functions[i];
            if (expression.length() - 2 < temp.length()) continue;
            if (expression.substring(0, temp.length()).equals(temp)) {
                function = temp;
                break;
            }
            temp = null;
        }
        if (function == null) {
            return null;
        }
        if (expression.charAt(function.length()) != '[') {
            return null;
        }
        int level = 0;
        for (int i = temp.length() + 1; i < expression.length() - 2; ++i) {
            char c = expression.charAt(i);
            if (c == '[') {
                ++level;
            }
            if (c == ']') {
                --level;
            }
            if (level < 0) {
                return null;
            }
            if (c != ',' || level != 0) continue;
            throw new ParserException("Sin, Cos, Tan and others scalar functions take only one argument.");
        }
        String argument = expression.substring(temp.length() + 1, expression.length() - 1);
        return new ParseTokenScalarFunction(temp, new ParseToken[]{parser.parse(argument)});
    }
}

