/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.NodeParserComparator;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParserBrackets;
import cc.redberry.core.parser.ParserDerivative;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.ParserExpression;
import cc.redberry.core.parser.ParserFunctions;
import cc.redberry.core.parser.ParserNumber;
import cc.redberry.core.parser.ParserPower;
import cc.redberry.core.parser.ParserPowerAst;
import cc.redberry.core.parser.ParserProduct;
import cc.redberry.core.parser.ParserSimpleTensor;
import cc.redberry.core.parser.ParserSum;
import cc.redberry.core.parser.ParserTensorField;
import cc.redberry.core.parser.TokenParser;
import java.util.Arrays;

public final class Parser {
    public static final Parser DEFAULT = new Parser(ParserBrackets.INSTANCE, ParserSum.INSTANCE, ParserProduct.INSTANCE, ParserSimpleTensor.INSTANCE, ParserTensorField.INSTANCE, ParserDerivative.INSTANCE, ParserPower.INSTANCE, ParserNumber.INSTANCE, ParserFunctions.INSTANCE, ParserExpression.INSTANCE, ParserPowerAst.INSTANCE);
    private final TokenParser[] tokenParsers;

    public Parser(TokenParser ... tokenParsers) {
        this.tokenParsers = tokenParsers;
        Arrays.sort(tokenParsers, NodeParserComparator.INSTANCE);
    }

    public ParseToken parse(String expression) {
        expression = expression.replaceAll("//.*|(\"(?:\\\\[^\"]|\\\\\"|.)*?\")|(?s)/\\*.*?\\*/", "");
        if ((expression = expression.replaceAll("\n", "")).isEmpty()) {
            throw new IllegalArgumentException("Empty expression.");
        }
        for (TokenParser tokenParser : this.tokenParsers) {
            ParseToken node = tokenParser.parseToken(expression.trim(), this);
            if (node == null) continue;
            return node;
        }
        throw new ParserException("No appropriate parser for expression: \"" + expression + "\"");
    }
}

