/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number.parser;

import cc.redberry.core.number.Numeric;
import cc.redberry.core.number.Rational;
import cc.redberry.core.number.Real;
import cc.redberry.core.number.parser.NumberParser;
import cc.redberry.core.number.parser.TokenParser;
import java.math.BigInteger;

public class RealToken
implements TokenParser<Real> {
    public static final RealToken INSTANCE = new RealToken();

    private RealToken() {
    }

    @Override
    public Real parse(String expression, NumberParser<Real> parser) {
        try {
            return new Rational(new BigInteger(expression));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Numeric(Double.parseDouble(expression));
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }
    }
}

