/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.Context;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.indices.AbstractIndices;
import cc.redberry.core.indices.EmptyIndices;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.MathUtils;
import java.util.Arrays;
import java.util.EnumSet;

public final class IndicesUtils {
    public static final int UPPER_RAW_STATE_INT = Integer.MIN_VALUE;
    public static final int LOWER_RAW_STATE_INT = Integer.MIN_VALUE;

    private IndicesUtils() {
    }

    public static int createIndex(int name, IndexType type, boolean state) {
        return IndicesUtils.createIndex(name, type.getType(), state);
    }

    public static int createIndex(int name, byte type, boolean state) {
        return name & 0xFFFF | (0x7F & type) << 24 | (state ? Integer.MIN_VALUE : 0);
    }

    public static int getRawStateInt(int index) {
        return index & Integer.MIN_VALUE;
    }

    public static int getStateInt(int index) {
        return (index & Integer.MIN_VALUE) >>> 31;
    }

    public static boolean getState(int index) {
        return (index & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public static int inverseIndexState(int index) {
        return Integer.MIN_VALUE ^ index;
    }

    public static int getNameWithType(int index) {
        return index & Integer.MAX_VALUE;
    }

    public static int setType(byte type, int index) {
        return 0x80FFFFFF & index | (0x7F & type) << 24;
    }

    public static int setType(IndexType type, int index) {
        return IndicesUtils.setType(type.getType(), index);
    }

    public static int setRawState(int rawState, int index) {
        return rawState | index & Integer.MAX_VALUE;
    }

    public static int setState(boolean state, int index) {
        return IndicesUtils.setRawState(state ? Integer.MIN_VALUE : 0, index);
    }

    public static int getNameWithoutType(int index) {
        return index & 0xFFFF;
    }

    public static byte getType(int index) {
        return (byte)((index & Integer.MAX_VALUE) >>> 24);
    }

    public static IndexType getTypeEnum(int index) {
        return IndexType.getType(IndicesUtils.getType(index));
    }

    public static int getTypeInt(int index) {
        return (index & Integer.MAX_VALUE) >>> 24;
    }

    public static int getRawTypeInt(int index) {
        return index & 0x7F000000;
    }

    public static byte getTypeWithState(int index) {
        return (byte)(index >>> 24);
    }

    public static boolean hasEqualTypeAndName(int index0, int index1) {
        return (index0 & Integer.MAX_VALUE) == (index1 & Integer.MAX_VALUE);
    }

    public static boolean hasEqualTypes(int index0, int index1) {
        return (index0 & 0x7F000000) == (index1 & 0x7F000000);
    }

    public static boolean hasEqualTypesAndStates(int index0, int index1) {
        return (index0 & 0xFF000000) == (index1 & 0xFF000000);
    }

    public static boolean areContracted(int index0, int index1) {
        return (index0 ^ index1) == Integer.MIN_VALUE;
    }

    public static int[] getSortedDistinctIndicesNames(Indices indices) {
        int[] indsArray = indices.getAllIndices().copy();
        for (int i = 0; i < indsArray.length; ++i) {
            indsArray[i] = IndicesUtils.getNameWithType(indsArray[i]);
        }
        return MathUtils.getSortedDistinct(indsArray);
    }

    public static String toString(int index, OutputFormat mode) {
        return (IndicesUtils.getState(index) ? "^" : "_") + Context.get().getIndexConverterManager().getSymbol(index, mode) + "";
    }

    public static String toString(int index) {
        return IndicesUtils.toString(index, Context.get().getDefaultOutputFormat());
    }

    public static String toString(int[] indices, OutputFormat mode) {
        return IndicesFactory.createSimple(null, indices).toString(mode);
    }

    public static String toString(int[] indices) {
        return IndicesUtils.toString(indices, CC.getDefaultOutputFormat());
    }

    public static int parseIndex(String string) {
        boolean state = (string = string.trim()).charAt(0) == '^';
        int start = 0;
        if (string.charAt(0) == '^' || string.charAt(0) == '_') {
            start = 1;
        }
        int nameWithType = string.charAt(start) == '{' ? Context.get().getIndexConverterManager().getCode(string.substring(start + 1, string.length() - 1)) : Context.get().getIndexConverterManager().getCode(string.substring(start));
        return state ? Integer.MIN_VALUE ^ nameWithType : nameWithType;
    }

    public static int[] getIndicesNames(Indices indices) {
        int[] a = new int[indices.size()];
        for (int i = indices.size() - 1; i >= 0; --i) {
            a[i] = IndicesUtils.getNameWithType(indices.get(i));
        }
        return a;
    }

    public static int[] getIndicesNames(int[] indices) {
        int[] a = new int[indices.length];
        for (int i = a.length - 1; i >= 0; --i) {
            a[i] = IndicesUtils.getNameWithType(indices[i]);
        }
        return a;
    }

    public static int[] getIndicesNames(IntArray indices) {
        int[] a = new int[indices.length()];
        for (int i = a.length - 1; i >= 0; --i) {
            a[i] = IndicesUtils.getNameWithType(indices.get(i));
        }
        return a;
    }

    public static int[] getFree(int[] indices) {
        return IndicesFactory.createSimple(null, indices).getFree().getAllIndices().copy();
    }

    public static boolean haveEqualStates(int index1, int index2) {
        return IndicesUtils.getRawStateInt(index1) == IndicesUtils.getRawStateInt(index2);
    }

    public static boolean isPermutationConsistentWithIndices(int[] indices, int[] permutation) {
        if (indices.length != permutation.length) {
            return false;
        }
        for (int i = 0; i < permutation.length; ++i) {
            if (IndicesUtils.getRawTypeInt(indices[i]) == IndicesUtils.getRawTypeInt(indices[permutation[i]])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPermutationConsistentWithIndices(int[] indices, Permutation permutation) {
        if (indices.length < permutation.degree()) {
            return false;
        }
        int s = permutation.degree();
        for (int i = 0; i < s; ++i) {
            if (IndicesUtils.getRawTypeInt(indices[i]) == IndicesUtils.getRawTypeInt(indices[permutation.newIndexOf(i)])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsRegardlessOrder(Indices indices1, int[] indices2) {
        if (indices1 instanceof EmptyIndices) {
            return indices2.length == 0;
        }
        if (indices1.size() != indices2.length) {
            return false;
        }
        int[] temp = (int[])indices2.clone();
        Arrays.sort(temp);
        return Arrays.equals(((AbstractIndices)indices1).getSortedData(), temp);
    }

    public static boolean equalsRegardlessOrder(int[] indices1, int[] indices2) {
        if (indices1.length != indices2.length) {
            return false;
        }
        int[] temp1 = (int[])indices1.clone();
        int[] temp2 = (int[])indices2.clone();
        Arrays.sort(temp1);
        Arrays.sort(temp2);
        return Arrays.equals(temp1, temp2);
    }

    public static boolean haveIntersections(Indices u, Indices v) {
        Indices uFree = u.getFree();
        Indices vFree = v.getFree();
        if (uFree.size() > vFree.size()) {
            Indices temp = uFree;
            uFree = vFree;
            vFree = temp;
        }
        for (int i = 0; i < uFree.size(); ++i) {
            for (int j = 0; j < vFree.size(); ++j) {
                if (vFree.get(j) != IndicesUtils.inverseIndexState(uFree.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] getIntersections(int[] freeIndices1, int[] freeIndices2) {
        if (freeIndices1.length > freeIndices2.length) {
            int[] temp = freeIndices1;
            freeIndices1 = freeIndices2;
            freeIndices2 = temp;
        }
        IntArrayList contracted = new IntArrayList();
        for (int i = 0; i < freeIndices1.length; ++i) {
            for (int j = 0; j < freeIndices2.length; ++j) {
                if (freeIndices2[j] != IndicesUtils.inverseIndexState(freeIndices1[i])) continue;
                contracted.add(IndicesUtils.getNameWithType(freeIndices2[j]));
            }
        }
        return contracted.toArray();
    }

    public static int[] getIntersections(Indices u, Indices v) {
        if (u.size() == 0 || v.size() == 0) {
            return new int[0];
        }
        Indices freeU = u.getFree();
        Indices freeV = v.getFree();
        if (freeU.size() == 0 || freeV.size() == 0) {
            return new int[0];
        }
        return IndicesUtils.getIntersections(((AbstractIndices)freeU).data, ((AbstractIndices)freeV).data);
    }

    public static boolean containsNonMetric(Indices indices) {
        for (int i = 0; i < indices.size(); ++i) {
            if (CC.isMetric(IndicesUtils.getType(indices.get(i)))) continue;
            return true;
        }
        return false;
    }

    public static EnumSet<IndexType> nonMetricTypes(Indices indices) {
        EnumSet<IndexType> types = EnumSet.noneOf(IndexType.class);
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            if (CC.isMetric(IndicesUtils.getType(index))) continue;
            types.add(IndicesUtils.getTypeEnum(index));
        }
        return types;
    }
}

