/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.indices.AbstractSimpleIndices;
import cc.redberry.core.indices.EmptyIndices;
import cc.redberry.core.indices.EmptySimpleIndices;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesSymmetries;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.SimpleIndicesIsolated;
import cc.redberry.core.indices.SortedIndices;

public class IndicesFactory {
    public static final Indices EMPTY_INDICES = EmptyIndices.EMPTY_INDICES_INSTANCE;
    public static final SimpleIndices EMPTY_SIMPLE_INDICES = EmptySimpleIndices.EMPTY_SIMPLE_INDICES_INSTANCE;

    public static SimpleIndices createSimple(IndicesSymmetries symmetries, int ... data) {
        if (data.length == 0) {
            return EmptySimpleIndices.EMPTY_SIMPLE_INDICES_INSTANCE;
        }
        return new SimpleIndicesIsolated((int[])data.clone(), symmetries);
    }

    public static SimpleIndices createSimple(IndicesSymmetries symmetries, Indices indices) {
        if (indices.size() == 0) {
            return EmptySimpleIndices.EMPTY_SIMPLE_INDICES_INSTANCE;
        }
        if (indices instanceof AbstractSimpleIndices) {
            return new SimpleIndicesIsolated(((AbstractSimpleIndices)indices).data, symmetries);
        }
        return new SimpleIndicesIsolated(indices.getAllIndices().copy(), symmetries);
    }

    public static Indices create(Indices indices) {
        if (indices.size() == 0) {
            return EMPTY_INDICES;
        }
        if (indices instanceof SortedIndices) {
            return indices;
        }
        return new SortedIndices(indices.getAllIndices().copy());
    }

    public static Indices create(int ... data) {
        if (data.length == 0) {
            return EMPTY_INDICES;
        }
        return new SortedIndices((int[])data.clone());
    }
}

