/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorException;

public class InconsistentIndicesException
extends TensorException {
    private final Integer index;

    public InconsistentIndicesException(int index) {
        super("Inconsistent index " + IndicesUtils.toString(index) + ".");
        this.index = index;
    }

    public InconsistentIndicesException(InconsistentIndicesException cause, Tensor inTensor) {
        this(cause.index, inTensor);
    }

    public InconsistentIndicesException(int index, Tensor inTensor) {
        super("Inconsistent index " + IndicesUtils.toString(index), inTensor);
        this.index = index;
    }

    public InconsistentIndicesException(Tensor inTensor) {
        super("Inconsistent indices", inTensor);
        this.index = null;
    }

    public Integer getIndex() {
        return this.index;
    }
}

