/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indexmapping.IndexMapping;
import cc.redberry.core.indices.AbstractIndices;
import cc.redberry.core.indices.EmptySimpleIndices;
import cc.redberry.core.indices.InconsistentIndicesException;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesSymmetries;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.indices.UnsafeIndicesFactory;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import java.util.Arrays;

abstract class AbstractSimpleIndices
extends AbstractIndices
implements SimpleIndices {
    IndicesSymmetries symmetries = null;

    AbstractSimpleIndices(int[] data, IndicesSymmetries symmetries) {
        super(data);
        assert (data.length != 0);
        int[] toSort = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            toSort[i] = data[i] & 0x7F000000;
        }
        ArraysUtils.stableSort(toSort, data);
        this.symmetries = symmetries;
        this.testConsistentWithException();
    }

    AbstractSimpleIndices(boolean notResort, int[] data, IndicesSymmetries symmetries) {
        super(data);
        assert (data.length != 0);
        this.symmetries = symmetries;
    }

    @Override
    public SimpleIndices getUpper() {
        AbstractIndices.UpperLowerIndices ul = this.getUpperLowerIndices();
        if (ul.upper.length == 0) {
            return EmptySimpleIndices.EMPTY_SIMPLE_INDICES_INSTANCE;
        }
        return UnsafeIndicesFactory.createIsolatedUnsafeWithoutSort0(null, ul.upper, new AbstractIndices.UpperLowerIndices(ul.upper, new int[0]));
    }

    @Override
    public SimpleIndices getLower() {
        AbstractIndices.UpperLowerIndices ul = this.getUpperLowerIndices();
        if (ul.lower.length == 0) {
            return EmptySimpleIndices.EMPTY_SIMPLE_INDICES_INSTANCE;
        }
        return UnsafeIndicesFactory.createIsolatedUnsafeWithoutSort0(null, ul.lower, new AbstractIndices.UpperLowerIndices(new int[0], ul.lower));
    }

    @Override
    protected AbstractIndices.UpperLowerIndices calculateUpperLower() {
        int upperCount = 0;
        for (int index : this.data) {
            if ((index & Integer.MIN_VALUE) != Integer.MIN_VALUE) continue;
            ++upperCount;
        }
        int[] lower = new int[this.data.length - upperCount];
        int[] upper = new int[upperCount];
        int ui = 0;
        int li = 0;
        for (int index : this.data) {
            if ((index & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                upper[ui++] = index;
                continue;
            }
            lower[li++] = index;
        }
        return new AbstractIndices.UpperLowerIndices(upper, lower);
    }

    @Override
    public int size(IndexType type) {
        int i;
        int type_ = type.getType() << 24;
        for (i = 0; i < this.data.length && (this.data[i] & 0x7F000000) != type_; ++i) {
        }
        int size = 0;
        while (i + size < this.data.length && (this.data[i + size] & 0x7F000000) == type_) {
            ++size;
        }
        return size;
    }

    @Override
    public int get(IndexType type, int position) {
        int i;
        int type_ = type.getType() << 24;
        for (i = 0; i < this.data.length && (this.data[i] & 0x7F000000) != type_; ++i) {
        }
        int index = this.data[i + position];
        if ((index & 0x7F000000) != type_) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    @Override
    public SimpleIndices getInverted() {
        int[] dataInv = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            dataInv[i] = this.data[i] ^ Integer.MIN_VALUE;
        }
        return this.create(dataInv, this.symmetries);
    }

    @Override
    public SimpleIndices getFree() {
        IntArrayList dataList = new IntArrayList();
        for (int i = 0; i < this.data.length; ++i) {
            boolean y = true;
            for (int j = 0; j < this.data.length; ++j) {
                if (i == j || (this.data[i] ^ this.data[j]) != Integer.MIN_VALUE) continue;
                y = false;
                break;
            }
            if (!y) continue;
            dataList.add(this.data[i]);
        }
        return UnsafeIndicesFactory.createIsolatedUnsafeWithoutSort(null, dataList.toArray());
    }

    @Override
    public int[] getNamesOfDummies() {
        IntArrayList dataList = new IntArrayList();
        block0: for (int i = 0; i < this.data.length; ++i) {
            for (int j = i + 1; j < this.data.length; ++j) {
                if ((this.data[i] ^ this.data[j]) != Integer.MIN_VALUE) continue;
                dataList.add(this.data[i] & Integer.MAX_VALUE);
                continue block0;
            }
        }
        return dataList.toArray();
    }

    @Override
    public SimpleIndices getOfType(IndexType type) {
        int i;
        int type_ = type.getType() << 24;
        for (i = 0; i < this.data.length && (this.data[i] & 0x7F000000) != type_; ++i) {
        }
        int start = i;
        while (i < this.data.length && (this.data[i] & 0x7F000000) == type_) {
            ++i;
        }
        int[] newData = start == 0 && i == this.data.length ? this.data : Arrays.copyOfRange(this.data, start, i);
        return UnsafeIndicesFactory.createIsolatedUnsafeWithoutSort(null, newData);
    }

    @Override
    public SimpleIndices applyIndexMapping(IndexMapping mapping) {
        boolean changed = false;
        int[] data_ = (int[])this.data.clone();
        for (int i = 0; i < this.data.length; ++i) {
            int newIndex = mapping.map(data_[i]);
            if (data_[i] == newIndex) continue;
            data_[i] = newIndex;
            changed = true;
        }
        if (!changed) {
            return this;
        }
        SimpleIndices si = this.create(data_, this.symmetries);
        si.testConsistentWithException();
        return si;
    }

    abstract SimpleIndices create(int[] var1, IndicesSymmetries var2);

    @Override
    int[] getSortedData() {
        int[] sorted = (int[])this.data.clone();
        Arrays.sort(sorted);
        return sorted;
    }

    @Override
    public final void testConsistentWithException() {
        for (int i = 0; i < this.data.length - 1; ++i) {
            for (int j = i + 1; j < this.data.length; ++j) {
                if (this.data[i] != this.data[j]) continue;
                throw new InconsistentIndicesException(this.data[i]);
            }
        }
    }

    @Override
    public boolean equalsWithSymmetries(SimpleIndices indices) {
        if (indices.getClass() != this.getClass()) {
            return false;
        }
        if (this.data.length != indices.size()) {
            return false;
        }
        int[] permutation = new int[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            block6: {
                int from = this.data[i];
                for (int j = 0; j < this.data.length; ++j) {
                    if (indices.get(j) != from) {
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            permutation[j] = i++;
        }
        if (!Permutations.testPermutationCorrectness(permutation)) {
            return false;
        }
        return this.getSymmetries().getPermutationGroup().membershipTest(Permutations.createPermutation(permutation));
    }

    @Override
    public short[] getPositionsInOrbits() {
        return this.symmetries.getPositionsInOrbits();
    }

    @Override
    public StructureOfIndices getStructureOfIndices() {
        return StructureOfIndices.create(this);
    }
}

