/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.context.Context;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.InconsistentIndicesException;
import cc.redberry.core.indices.IndicesUtils;

final class IndexMappingBufferRecord {
    byte states;
    private final int toName;

    public IndexMappingBufferRecord(int from, int to) {
        this.toName = IndicesUtils.getNameWithType(to);
        this.states = (byte)(this.states | 1 << IndicesUtils.getStateInt(to));
        this.states = (byte)(this.states | (IndicesUtils.getStateInt(from) ^ IndicesUtils.getStateInt(to)) << 2);
    }

    public IndexMappingBufferRecord(byte usedStates, int indexName) {
        this.states = usedStates;
        this.toName = indexName;
    }

    public boolean tryMap(int from, int to) {
        if (IndicesUtils.getNameWithType(to) != this.toName) {
            return false;
        }
        if (IndicesUtils.getStateInt(from) != IndicesUtils.getStateInt(to) != ((this.states & 4) == 4)) {
            throw new InconsistentIndicesException(from);
        }
        if ((this.states & 1 << IndicesUtils.getStateInt(to)) != 0) {
            throw new InconsistentIndicesException(to);
        }
        this.states = (byte)(this.states | 1 << IndicesUtils.getStateInt(to));
        return true;
    }

    public int getIndexName() {
        return this.toName;
    }

    public byte getStates() {
        return this.states;
    }

    public int getToRawState() {
        return (this.states & 1) == 0 ? Integer.MIN_VALUE : 0;
    }

    public int getFromRawState() {
        if ((this.states & 4) == 0) {
            return this.getToRawState();
        }
        return Integer.MIN_VALUE ^ this.getToRawState();
    }

    public boolean getStatesBit(int bit) {
        return (this.states >>> bit & 1) == 1;
    }

    public boolean isContracted() {
        return (this.states & 3) == 3;
    }

    public boolean diffStatesInitialized() {
        return (this.states & 4) == 4;
    }

    public int getRawDiffStateBit() {
        return (this.states & 4) << 29;
    }

    public void invertStates() {
        if (this.isContracted()) {
            return;
        }
        this.states = (byte)(this.states ^ 3);
    }

    public IndexMappingBufferRecord clone() {
        return new IndexMappingBufferRecord(this.states, this.toName);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexMappingBufferRecord other = (IndexMappingBufferRecord)obj;
        if (this.states != other.states) {
            return false;
        }
        return this.toName == other.toName;
    }

    public int hashCode() {
        return 31 * (217 + this.states) + this.toName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Context.get().getIndexConverterManager().getSymbol(this.getIndexName(), OutputFormat.UTF8));
        sb.append(":");
        for (int i = 2; i >= 0; --i) {
            sb.append(this.getStatesBit(i) ? 1 : 0);
        }
        return sb.toString();
    }
}

