/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.context.CC;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.PermutationOneLineByte;
import cc.redberry.core.groups.permutations.PermutationOneLineInt;
import cc.redberry.core.groups.permutations.PermutationOneLineShort;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.MathUtils;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;

public final class Permutations {
    private static final Permutation[] cachedIdentities = new Permutation[128];
    public static final int DEFAULT_IDENTITY_LENGTH = 10;

    private Permutations() {
    }

    public static int internalDegree(int[] permutation) {
        int i;
        for (i = permutation.length - 1; i >= 0 && permutation[i] == i; --i) {
        }
        return i + 1;
    }

    public static short internalDegree(short[] permutation) {
        int i;
        for (i = permutation.length - 1; i >= 0 && permutation[i] == i; --i) {
        }
        return (short)(i + 1);
    }

    public static byte internalDegree(byte[] permutation) {
        int i;
        for (i = permutation.length - 1; i >= 0 && permutation[i] == i; --i) {
        }
        return (byte)(i + 1);
    }

    public static int internalDegree(List<? extends Permutation> permutations) {
        int r = 0;
        for (Permutation permutation : permutations) {
            r = Math.max(r, permutation.degree());
        }
        return r;
    }

    public static int parity(int[] permutation) {
        BitArray used = new BitArray(permutation.length);
        int counter = 0;
        int numOfTranspositions = 0;
        while (counter < permutation.length) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            int currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            counter += currentSize;
            numOfTranspositions += currentSize - 1;
        }
        return numOfTranspositions % 2;
    }

    public static int parity(short[] permutation) {
        BitArray used = new BitArray(permutation.length);
        int counter = 0;
        int numOfTranspositions = 0;
        while (counter < permutation.length) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            int currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            counter += currentSize;
            numOfTranspositions += currentSize - 1;
        }
        return numOfTranspositions % 2;
    }

    public static int parity(byte[] permutation) {
        BitArray used = new BitArray(permutation.length);
        int counter = 0;
        int numOfTranspositions = 0;
        while (counter < permutation.length) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            int currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            counter += currentSize;
            numOfTranspositions += currentSize - 1;
        }
        return numOfTranspositions % 2;
    }

    public static boolean isIdentity(int[] permutation) {
        for (int i = 0; i < permutation.length; ++i) {
            if (i == permutation[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentity(short[] permutation) {
        for (int i = 0; i < permutation.length; ++i) {
            if (i == permutation[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentity(byte[] permutation) {
        for (int i = 0; i < permutation.length; ++i) {
            if (i == permutation[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean testPermutationCorrectness(int[] permutation, boolean sign) {
        return Permutations.testPermutationCorrectness(permutation) && (!sign || !Permutations.orderOfPermutationIsOdd(permutation));
    }

    public static boolean testPermutationCorrectness(short[] permutation, boolean sign) {
        return Permutations.testPermutationCorrectness(permutation) && (!sign || !Permutations.orderOfPermutationIsOdd(permutation));
    }

    public static boolean testPermutationCorrectness(byte[] permutation, boolean sign) {
        return Permutations.testPermutationCorrectness(permutation) && (!sign || !Permutations.orderOfPermutationIsOdd(permutation));
    }

    public static boolean testPermutationCorrectness(int[] permutation) {
        int length = permutation.length;
        BitArray checked = new BitArray(length);
        for (int i = 0; i < length; ++i) {
            if (permutation[i] >= length || permutation[i] < 0) {
                return false;
            }
            if (checked.get(permutation[i])) {
                return false;
            }
            checked.set(permutation[i]);
        }
        return checked.isFull();
    }

    public static boolean testPermutationCorrectness(short[] permutation) {
        int length = permutation.length;
        BitArray checked = new BitArray(length);
        for (int i = 0; i < length; ++i) {
            if (permutation[i] >= length || permutation[i] < 0) {
                return false;
            }
            if (checked.get(permutation[i])) {
                return false;
            }
            checked.set(permutation[i]);
        }
        return checked.isFull();
    }

    public static boolean testPermutationCorrectness(byte[] permutation) {
        int length = permutation.length;
        BitArray checked = new BitArray(length);
        for (int i = 0; i < length; ++i) {
            if (permutation[i] >= length || permutation[i] < 0) {
                return false;
            }
            if (checked.get(permutation[i])) {
                return false;
            }
            checked.set(permutation[i]);
        }
        return checked.isFull();
    }

    public static BigInteger orderOfPermutation(int[] permutation) {
        int currentSize;
        BitArray used = new BitArray(permutation.length);
        BigInteger lcm = BigInteger.ONE;
        for (int counter = 0; counter < permutation.length; counter += currentSize) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            BigInteger temp = BigInteger.valueOf(currentSize);
            lcm = lcm.divide(lcm.gcd(temp)).multiply(temp);
        }
        return lcm;
    }

    public static BigInteger orderOfPermutation(short[] permutation) {
        int currentSize;
        BitArray used = new BitArray(permutation.length);
        BigInteger lcm = BigInteger.ONE;
        for (int counter = 0; counter < permutation.length; counter += currentSize) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            BigInteger temp = BigInteger.valueOf(currentSize);
            lcm = lcm.divide(lcm.gcd(temp)).multiply(temp);
        }
        return lcm;
    }

    public static BigInteger orderOfPermutation(byte[] permutation) {
        int currentSize;
        BitArray used = new BitArray(permutation.length);
        BigInteger lcm = BigInteger.ONE;
        for (int counter = 0; counter < permutation.length; counter += currentSize) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            BigInteger temp = BigInteger.valueOf(currentSize);
            lcm = lcm.divide(lcm.gcd(temp)).multiply(temp);
        }
        return lcm;
    }

    public static boolean orderOfPermutationIsOdd(int[] permutation) {
        int currentSize;
        BitArray used = new BitArray(permutation.length);
        for (int counter = 0; counter < permutation.length; counter += currentSize) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            if (currentSize % 2 != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean orderOfPermutationIsOdd(short[] permutation) {
        int currentSize;
        BitArray used = new BitArray(permutation.length);
        for (int counter = 0; counter < permutation.length; counter += currentSize) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            if (currentSize % 2 != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean orderOfPermutationIsOdd(byte[] permutation) {
        int currentSize;
        BitArray used = new BitArray(permutation.length);
        for (int counter = 0; counter < permutation.length; counter += currentSize) {
            int pointer;
            int start = pointer = used.nextZeroBit(0);
            currentSize = 0;
            do {
                assert (!used.get(pointer));
                used.set(pointer);
                pointer = permutation[pointer];
                ++currentSize;
            } while (pointer != start);
            if (currentSize % 2 != 0) continue;
            return false;
        }
        return true;
    }

    public static IntArrayList getOrbitList(List<Permutation> generators, int point) {
        return Permutations.getOrbitList(generators, point, Permutations.internalDegree(generators));
    }

    public static IntArrayList getOrbitList(Collection<Permutation> generators, int point, int degree) {
        IntArrayList orbitList = new IntArrayList();
        orbitList.add(point);
        if (generators.isEmpty()) {
            return orbitList;
        }
        BitArray seen = new BitArray(degree);
        seen.set(point);
        for (int orbitIndex = 0; orbitIndex < orbitList.size(); ++orbitIndex) {
            for (Permutation generator : generators) {
                int imageOfPoint = generator.newIndexOf(orbitList.get(orbitIndex));
                if (seen.get(imageOfPoint)) continue;
                orbitList.add(imageOfPoint);
                seen.set(imageOfPoint);
            }
        }
        return orbitList;
    }

    public static int getOrbitSize(List<Permutation> generators, int point, int degree) {
        return Permutations.getOrbitList(generators, point, degree).size();
    }

    public static int getOrbitSize(List<Permutation> generators, int point) {
        return Permutations.getOrbitList(generators, point, Permutations.internalDegree(generators)).size();
    }

    public static int[][] orbits(List<Permutation> generators, int[] positionsInOrbit) {
        if (generators.isEmpty()) {
            return new int[0][0];
        }
        ArrayList<int[]> orbits = new ArrayList<int[]>();
        Arrays.fill(positionsInOrbit, -1);
        int seenCount = 0;
        int orbitsIndex = 0;
        while (seenCount < positionsInOrbit.length) {
            IntArrayList orbitList = new IntArrayList();
            int point = -1;
            for (int i = 0; i < positionsInOrbit.length; ++i) {
                if (positionsInOrbit[i] != -1) continue;
                point = i;
                break;
            }
            assert (point != -1);
            orbitList.add(point);
            ++seenCount;
            positionsInOrbit[point] = orbitsIndex;
            for (int orbitIndex = 0; orbitIndex < orbitList.size(); ++orbitIndex) {
                for (Permutation generator : generators) {
                    int imageOfPoint = generator.newIndexOf(orbitList.get(orbitIndex));
                    if (positionsInOrbit[imageOfPoint] != -1) continue;
                    ++seenCount;
                    positionsInOrbit[imageOfPoint] = orbitsIndex;
                    orbitList.add(imageOfPoint);
                }
            }
            orbits.add(orbitList.toArray());
            ++orbitsIndex;
        }
        return (int[][])orbits.toArray((T[])new int[orbits.size()][]);
    }

    public static int[] convertCyclesToOneLine(int[][] cycles) {
        int degree = -1;
        for (int[] cycle : cycles) {
            degree = Math.max(degree, ArraysUtils.max(cycle));
        }
        int[] permutation = new int[++degree];
        for (int i = 1; i < degree; ++i) {
            permutation[i] = i;
        }
        for (int[] cycle : cycles) {
            if (cycle.length == 0) continue;
            if (cycle.length == 1) {
                throw new IllegalArgumentException("Illegal use of cycle notation: " + Arrays.toString(cycle));
            }
            int s = cycle.length - 1;
            for (int k = 0; k < s; ++k) {
                permutation[cycle[k]] = cycle[k + 1];
            }
            permutation[cycle[cycle.length - 1]] = cycle[0];
        }
        return permutation;
    }

    public static int[][] convertOneLineToCycles(int[] permutation) {
        ArrayList<int[]> cycles = new ArrayList<int[]>();
        BitArray seen = new BitArray(permutation.length);
        int counter = 0;
        while (counter < permutation.length) {
            int start = seen.nextZeroBit(0);
            if (permutation[start] == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            IntArrayList cycle = new IntArrayList();
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                cycle.add(start);
                start = permutation[start];
            }
            cycles.add(cycle.toArray());
        }
        return (int[][])cycles.toArray((T[])new int[cycles.size()][]);
    }

    public static int[][] convertOneLineToCycles(short[] permutation) {
        ArrayList<int[]> cycles = new ArrayList<int[]>();
        BitArray seen = new BitArray(permutation.length);
        int counter = 0;
        while (counter < permutation.length) {
            int start = seen.nextZeroBit(0);
            if (permutation[start] == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            IntArrayList cycle = new IntArrayList();
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                cycle.add(start);
                start = permutation[start];
            }
            cycles.add(cycle.toArray());
        }
        return (int[][])cycles.toArray((T[])new int[cycles.size()][]);
    }

    public static int[][] convertOneLineToCycles(byte[] permutation) {
        ArrayList<int[]> cycles = new ArrayList<int[]>();
        BitArray seen = new BitArray(permutation.length);
        int counter = 0;
        while (counter < permutation.length) {
            int start = seen.nextZeroBit(0);
            if (permutation[start] == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            IntArrayList cycle = new IntArrayList();
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                cycle.add(start);
                start = permutation[start];
            }
            cycles.add(cycle.toArray());
        }
        return (int[][])cycles.toArray((T[])new int[cycles.size()][]);
    }

    public static int[] lengthsOfCycles(int[] permutation) {
        IntArrayList sizes = new IntArrayList();
        BitArray seen = new BitArray(permutation.length);
        int counter = 0;
        while (counter < permutation.length) {
            int start = seen.nextZeroBit(0);
            if (permutation[start] == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            int size = 0;
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                ++size;
                start = permutation[start];
            }
            sizes.add(size);
        }
        return sizes.toArray();
    }

    public static int[] lengthsOfCycles(short[] permutation) {
        IntArrayList sizes = new IntArrayList();
        BitArray seen = new BitArray(permutation.length);
        int counter = 0;
        while (counter < permutation.length) {
            int start = seen.nextZeroBit(0);
            if (permutation[start] == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            int size = 0;
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                ++size;
                start = permutation[start];
            }
            sizes.add(size);
        }
        return sizes.toArray();
    }

    public static int[] lengthsOfCycles(byte[] permutation) {
        IntArrayList sizes = new IntArrayList();
        BitArray seen = new BitArray(permutation.length);
        int counter = 0;
        while (counter < permutation.length) {
            int start = seen.nextZeroBit(0);
            if (permutation[start] == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            int size = 0;
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                ++size;
                start = permutation[start];
            }
            sizes.add(size);
        }
        return sizes.toArray();
    }

    public static int[] randomPermutation(int n, RandomGenerator rnd) {
        int i;
        int[] p = new int[n];
        for (i = 0; i < n; ++i) {
            p[i] = i;
        }
        for (i = n; i > 1; --i) {
            ArraysUtils.swap(p, i - 1, rnd.nextInt(i));
        }
        for (i = n; i > 1; --i) {
            ArraysUtils.swap(p, i - 1, rnd.nextInt(i));
        }
        return p;
    }

    public static int[] randomPermutation(int n) {
        return Permutations.randomPermutation(n, CC.getRandomGenerator());
    }

    public static void shuffle(int[] a) {
        Permutations.shuffle(a, CC.getRandomGenerator());
    }

    public static void shuffle(int[] a, RandomGenerator rnd) {
        for (int i = a.length; i > 1; --i) {
            ArraysUtils.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(Object[] a, RandomGenerator rnd) {
        for (int i = a.length; i > 1; --i) {
            ArraysUtils.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(Object[] a) {
        Permutations.shuffle(a, CC.getRandomGenerator());
    }

    public static Permutation createPermutation(boolean antisymmetry, int[][] cycles) {
        return Permutations.createPermutation(antisymmetry, Permutations.convertCyclesToOneLine(cycles));
    }

    public static Permutation createPermutation(int[][] cycles) {
        return Permutations.createPermutation(false, Permutations.convertCyclesToOneLine(cycles));
    }

    public static Permutation createPermutation(int ... oneLine) {
        return Permutations.createPermutation(false, oneLine);
    }

    public static Permutation createPermutation(boolean antisymmetry, int ... oneLine) {
        boolean _byte = true;
        boolean _short = true;
        for (int i : oneLine) {
            if (i > 32766) {
                _short = false;
                _byte = false;
                continue;
            }
            if (i <= 126) continue;
            _byte = false;
        }
        if (_byte) {
            return new PermutationOneLineByte(antisymmetry, ArraysUtils.int2byte(oneLine));
        }
        if (_short) {
            return new PermutationOneLineShort(antisymmetry, ArraysUtils.int2short(oneLine));
        }
        return new PermutationOneLineInt(antisymmetry, oneLine);
    }

    public static <T> T[] permute(T[] array, int[] permutation) {
        if (array.length != permutation.length) {
            throw new IllegalArgumentException();
        }
        if (!Permutations.testPermutationCorrectness(permutation)) {
            throw new IllegalArgumentException();
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] newArray = (Object[])Array.newInstance(type, array.length);
        for (int i = 0; i < permutation.length; ++i) {
            newArray[i] = array[permutation[i]];
        }
        return newArray;
    }

    public static <T> List<T> permute(List<T> array, int[] permutation) {
        if (array.size() != permutation.length) {
            throw new IllegalArgumentException();
        }
        if (!Permutations.testPermutationCorrectness(permutation)) {
            throw new IllegalArgumentException();
        }
        ArrayList<T> list = new ArrayList<T>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            list.add(array.get(permutation[i]));
        }
        return list;
    }

    public static int[] permute(int[] array, int[] permutation) {
        if (array.length != permutation.length) {
            throw new IllegalArgumentException();
        }
        if (!Permutations.testPermutationCorrectness(permutation)) {
            throw new IllegalArgumentException();
        }
        int[] newArray = new int[array.length];
        for (int i = 0; i < permutation.length; ++i) {
            newArray[i] = array[permutation[i]];
        }
        return newArray;
    }

    public static int[] getRandomSortedDistinctArray(int minValue, int maxvalue, int length, RandomGenerator generator) {
        if (maxvalue - minValue < length) {
            throw new IllegalArgumentException("This is not possible.");
        }
        if (length == 0) {
            return new int[0];
        }
        if (length == 1) {
            return new int[]{minValue + generator.nextInt(maxvalue - minValue)};
        }
        if (length == 2) {
            int b;
            int a = minValue + generator.nextInt(maxvalue - minValue);
            while ((b = minValue + generator.nextInt(maxvalue - minValue)) == a) {
            }
            return new int[]{a, b};
        }
        int[] res = new int[length + (int)(0.7 * (double)length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = minValue + generator.nextInt(maxvalue - minValue);
        }
        if ((res = MathUtils.getSortedDistinct(res)).length == length) {
            return res;
        }
        if (res.length > length) {
            return Arrays.copyOf(res, length);
        }
        while (res.length != length) {
            int next;
            while (Arrays.binarySearch(res, next = minValue + generator.nextInt(maxvalue - minValue)) >= 0) {
            }
            res = ArraysUtils.addAll(res, next);
        }
        return res;
    }

    public static int[] createIdentityArray(int length) {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static Permutation createIdentityPermutation(int degree) {
        if (degree < cachedIdentities.length) {
            if (cachedIdentities[degree] == null) {
                Permutations.cachedIdentities[degree] = Permutations.createPermutation(Permutations.createIdentityArray(degree));
            }
            return cachedIdentities[degree];
        }
        return Permutations.createPermutation(Permutations.createIdentityArray(degree));
    }

    public static Permutation getIdentityPermutation() {
        return Permutations.createIdentityPermutation(10);
    }

    public static int[] createTransposition(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("Dimension is negative.");
        }
        if (dimension > 1) {
            return Permutations.createTransposition(dimension, 0, 1);
        }
        return new int[dimension];
    }

    public static int[] createTransposition(int dimension, int position1, int position2) {
        int i;
        if (dimension < 0) {
            throw new IllegalArgumentException("Dimension is negative.");
        }
        if (position1 < 0 || position2 < 0) {
            throw new IllegalArgumentException("Negative index.");
        }
        if (position1 >= dimension || position2 >= dimension) {
            throw new IndexOutOfBoundsException();
        }
        int[] transposition = new int[dimension];
        for (i = 1; i < dimension; ++i) {
            transposition[i] = i;
        }
        i = transposition[position1];
        transposition[position1] = transposition[position2];
        transposition[position2] = i;
        return transposition;
    }

    public static int[] createCycle(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("Negative degree");
        }
        int[] cycle = new int[dimension];
        for (int i = 0; i < dimension - 1; ++i) {
            cycle[i + 1] = i;
        }
        cycle[0] = dimension - 1;
        return cycle;
    }

    public static int[] createBlockCycle(int blockSize, int numberOfBlocks) {
        int i;
        int[] cycle = new int[blockSize * numberOfBlocks];
        for (i = blockSize * (numberOfBlocks - 1) - 1; i >= 0; --i) {
            cycle[i] = i + blockSize;
        }
        int k = 0;
        for (i = blockSize * (numberOfBlocks - 1); i < cycle.length; ++i) {
            cycle[i] = k++;
        }
        return cycle;
    }

    public static int[] createBlockTransposition(int length1, int length2) {
        int i;
        int[] r = new int[length1 + length2];
        for (i = 0; i < length2; ++i) {
            r[i] = length1 + i;
        }
        while (i < r.length) {
            r[i] = i - length2;
            ++i;
        }
        return r;
    }

    public static int[] inverse(int[] permutation) {
        int[] inverse = new int[permutation.length];
        for (int i = 0; i < permutation.length; ++i) {
            inverse[permutation[i]] = i;
        }
        return inverse;
    }
}

