/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.IntComparator;
import java.util.Arrays;

public class InducedOrdering
implements IntComparator {
    private final int[] positions;
    private final int degree;

    public InducedOrdering(int[] base) {
        this.degree = ArraysUtils.max(base) + 1;
        this.positions = new int[this.degree + 2];
        Arrays.fill(this.positions, -1);
        for (int i = 0; i < base.length; ++i) {
            this.positions[1 + base[i]] = i;
        }
        int next = base.length;
        for (int i = 1; i < this.degree + 1; ++i) {
            if (this.positions[i] != -1) continue;
            this.positions[i] = next++;
        }
        this.positions[0] = Integer.MIN_VALUE;
        this.positions[this.degree + 1] = Integer.MAX_VALUE;
    }

    public int positionOf(int a) {
        return this.positions[a + 1];
    }

    @Override
    public int compare(int a, int b) {
        if (a > this.positions.length - 2) {
            return b > this.positions.length - 2 ? Integer.compare(a, b) : 1;
        }
        if (b > this.positions.length - 2) {
            return a > this.positions.length - 2 ? Integer.compare(a, b) : -1;
        }
        return Integer.compare(this.positions[a + 1], this.positions[b + 1]);
    }

    public int max(int a, int b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public int min(int a, int b) {
        return this.compare(a, b) >= 0 ? b : a;
    }

    public int maxElement() {
        return this.degree;
    }

    public int minElement() {
        return -1;
    }

    public int min(int[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException();
        }
        int min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = this.min(min, array[i]);
        }
        return min;
    }

    public int min(IntArrayList array) {
        if (array.size() == 0) {
            throw new IllegalArgumentException();
        }
        int min = array.get(array.size() - 1);
        for (int i = array.size() - 2; i >= 0; --i) {
            min = this.min(min, array.get(i));
        }
        return min;
    }

    public int max(int[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException();
        }
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = this.max(max, array[i]);
        }
        return max;
    }

    public int max(IntArrayList array) {
        if (array.size() == 0) {
            throw new IllegalArgumentException();
        }
        int max = array.get(array.size() - 1);
        for (int i = array.size() - 2; i >= 0; --i) {
            max = this.max(max, array.get(i));
        }
        return max;
    }
}

