/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.BSGSCandidateElement;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.groups.permutations.SchreierVector;
import cc.redberry.core.utils.IntArrayList;
import java.util.ArrayList;
import java.util.List;

public class BSGSElement {
    public final int basePoint;
    final List<Permutation> stabilizerGenerators;
    final SchreierVector SchreierVector;
    final IntArrayList orbitList;
    int internalDegree;

    BSGSElement(int basePoint, List<Permutation> stabilizerGenerators, SchreierVector schreierVector, IntArrayList orbitList) {
        this.basePoint = basePoint;
        this.stabilizerGenerators = stabilizerGenerators;
        this.SchreierVector = schreierVector;
        this.orbitList = orbitList;
        this.internalDegree = Permutations.internalDegree(stabilizerGenerators);
    }

    public List<Permutation> getStabilizerGeneratorsReference() {
        return this.stabilizerGenerators;
    }

    public Permutation getTransversalOf(int point) {
        Permutation transversal = this.getInverseTransversalOf(point).inverse();
        assert (transversal.newIndexOf(this.basePoint) == point);
        return transversal;
    }

    public Permutation getInverseTransversalOf(int point) {
        if (this.SchreierVector.get(point) == -2) {
            throw new IllegalArgumentException("Specified point does not belong to orbit of this base element.");
        }
        Permutation temp = Permutations.createIdentityPermutation(this.SchreierVector.length());
        while (this.SchreierVector.get(temp.newIndexOf(point)) != -1) {
            temp = temp.compositionWithInverse(this.stabilizerGenerators.get(this.SchreierVector.get(temp.newIndexOf(point))));
        }
        return temp;
    }

    public BSGSElement asBSGSElement() {
        return this;
    }

    public boolean belongsToOrbit(int point) {
        return this.SchreierVector.get(point) != -2;
    }

    public BSGSCandidateElement asBSGSCandidateElement() {
        return new BSGSCandidateElement(this.basePoint, new ArrayList<Permutation>(this.stabilizerGenerators), this.SchreierVector.length());
    }

    public int orbitSize() {
        return this.orbitList.size();
    }

    public int getOrbitPoint(int i) {
        return this.orbitList.get(i);
    }

    public int internalDegree() {
        return this.internalDegree;
    }

    public String toString() {
        return "[" + this.basePoint + ", " + this.stabilizerGenerators + "]";
    }
}

