/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.BSGSElement;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.SchreierVector;
import cc.redberry.core.utils.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BSGSCandidateElement
extends BSGSElement {
    BSGSCandidateElement(int basePoint, List<Permutation> stabilizerGenerators) {
        this(basePoint, stabilizerGenerators, BSGSCandidateElement.calculateSVCapacity(stabilizerGenerators));
        this.internalDegree = this.SchreierVector.length();
    }

    private static int calculateSVCapacity(List<Permutation> stabilizerGenerators) {
        int capacity = -1;
        for (Permutation p : stabilizerGenerators) {
            capacity = Math.max(capacity, p.degree());
        }
        return capacity;
    }

    BSGSCandidateElement(int basePoint, List<Permutation> stabilizerGenerators, int SchreierVectorCapacity) {
        super(basePoint, stabilizerGenerators, new SchreierVector(SchreierVectorCapacity), new IntArrayList());
        assert (stabilizerGenerators instanceof ArrayList);
        this.orbitList.add(basePoint);
        this.recalculateOrbitAndSchreierVector();
    }

    private BSGSCandidateElement(int basePoint, List<Permutation> stabilizerGenerators, SchreierVector schreierVector, IntArrayList orbitList) {
        super(basePoint, stabilizerGenerators, schreierVector, orbitList);
    }

    public void addStabilizer(Permutation stabilizer) {
        this.internalDegree = Math.max(this.internalDegree, stabilizer.degree());
        this.stabilizerGenerators.add(stabilizer);
        this.recalculateOrbitAndSchreierVector();
    }

    void recalculateOrbitAndSchreierVector() {
        this.orbitList.removeAfter(1);
        this.SchreierVector.reset();
        this.SchreierVector.set(this.basePoint, -1);
        for (int orbitIndex = 0; orbitIndex < this.orbitList.size(); ++orbitIndex) {
            int size = this.stabilizerGenerators.size();
            for (int stabilizerIndex = 0; stabilizerIndex < size; ++stabilizerIndex) {
                int imageOfPoint = ((Permutation)this.stabilizerGenerators.get(stabilizerIndex)).newIndexOf(this.orbitList.get(orbitIndex));
                if (this.SchreierVector.get(imageOfPoint) != -2) continue;
                this.orbitList.add(imageOfPoint);
                this.SchreierVector.set(imageOfPoint, stabilizerIndex);
            }
        }
    }

    public List<Permutation> getStabilizersOfThisBasePoint() {
        ArrayList<Permutation> basePointStabilizers = new ArrayList<Permutation>();
        for (Permutation previousPointsStabilizer : this.stabilizerGenerators) {
            if (previousPointsStabilizer.newIndexOf(this.basePoint) != this.basePoint) continue;
            basePointStabilizers.add(previousPointsStabilizer);
        }
        return basePointStabilizers;
    }

    @Override
    public BSGSElement asBSGSElement() {
        return new BSGSElement(this.basePoint, Collections.unmodifiableList(this.stabilizerGenerators), this.SchreierVector, this.orbitList.clone());
    }

    @Override
    public BSGSCandidateElement asBSGSCandidateElement() {
        return this;
    }

    public BSGSCandidateElement clone() {
        return new BSGSCandidateElement(this.basePoint, new ArrayList<Permutation>(this.stabilizerGenerators), this.SchreierVector.clone(), this.orbitList.clone());
    }
}

