/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context.defaults;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.context.defaults.SymbolArrayConverter;

public final class GreekLaTeXLowerCaseConverter
extends SymbolArrayConverter {
    private static final String[] symbols = new String[23];
    private static final String[] utf = new String[23];
    public static final GreekLaTeXLowerCaseConverter INSTANCE;
    public static final byte TYPE = 2;

    private GreekLaTeXLowerCaseConverter() {
        super(symbols, utf);
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public String getSymbol(int code, OutputFormat mode) throws IndexConverterException {
        String symbol;
        try {
            if (mode.is(OutputFormat.UTF8)) {
                return utf[code];
            }
            symbol = symbols[code];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexConverterException();
        }
        if (mode.is(OutputFormat.WolframMathematica)) {
            symbol = "\\[" + Character.toUpperCase(symbol.charAt(1)) + symbol.substring(2) + "]";
        }
        if (mode.is(OutputFormat.Maple)) {
            symbol = symbol.substring(1);
        }
        return symbol;
    }

    static {
        GreekLaTeXLowerCaseConverter.symbols[0] = "\\alpha";
        GreekLaTeXLowerCaseConverter.symbols[1] = "\\beta";
        GreekLaTeXLowerCaseConverter.symbols[2] = "\\gamma";
        GreekLaTeXLowerCaseConverter.symbols[3] = "\\delta";
        GreekLaTeXLowerCaseConverter.symbols[4] = "\\epsilon";
        GreekLaTeXLowerCaseConverter.symbols[5] = "\\zeta";
        GreekLaTeXLowerCaseConverter.symbols[6] = "\\eta";
        GreekLaTeXLowerCaseConverter.symbols[7] = "\\theta";
        GreekLaTeXLowerCaseConverter.symbols[8] = "\\iota";
        GreekLaTeXLowerCaseConverter.symbols[9] = "\\kappa";
        GreekLaTeXLowerCaseConverter.symbols[10] = "\\lambda";
        GreekLaTeXLowerCaseConverter.symbols[11] = "\\mu";
        GreekLaTeXLowerCaseConverter.symbols[12] = "\\nu";
        GreekLaTeXLowerCaseConverter.symbols[13] = "\\xi";
        GreekLaTeXLowerCaseConverter.symbols[14] = "\\pi";
        GreekLaTeXLowerCaseConverter.symbols[15] = "\\rho";
        GreekLaTeXLowerCaseConverter.symbols[16] = "\\sigma";
        GreekLaTeXLowerCaseConverter.symbols[17] = "\\tau";
        GreekLaTeXLowerCaseConverter.symbols[18] = "\\upsilon";
        GreekLaTeXLowerCaseConverter.symbols[19] = "\\phi";
        GreekLaTeXLowerCaseConverter.symbols[20] = "\\chi";
        GreekLaTeXLowerCaseConverter.symbols[21] = "\\psi";
        GreekLaTeXLowerCaseConverter.symbols[22] = "\\omega";
        for (int i = 0; i < 23; ++i) {
            char greekLetter = i >= 16 ? (char)(945 + i + 2) : (i >= 14 ? (char)(945 + i + 1) : (char)(945 + i));
            GreekLaTeXLowerCaseConverter.utf[i] = Character.toString(greekLetter);
        }
        INSTANCE = new GreekLaTeXLowerCaseConverter();
    }
}

