/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

public final class OutputFormat {
    public static final OutputFormat LaTeX = new OutputFormat(0, "^", "_");
    public static final OutputFormat UTF8 = new OutputFormat(1, "^", "_");
    public static final OutputFormat Redberry = new OutputFormat(2, "^", "_");
    public static final OutputFormat Cadabra = new OutputFormat(3, "^", "_");
    public static final OutputFormat WolframMathematica = new OutputFormat(4, "", "-");
    public static final OutputFormat Maple = new OutputFormat(5, "~", "");
    public static final OutputFormat SimpleRedberry = new OutputFormat(6, "^", "_", false);
    public final int id;
    public final String upperIndexPrefix;
    public final String lowerIndexPrefix;
    public final boolean printMatrixIndices;

    private OutputFormat(OutputFormat format, boolean printMatrixIndices) {
        this(format.id, format.upperIndexPrefix, format.lowerIndexPrefix, printMatrixIndices);
    }

    private OutputFormat(int id, String upperIndexPrefix, String lowerIndexPrefix) {
        this(id, upperIndexPrefix, lowerIndexPrefix, true);
    }

    private OutputFormat(int id, String upperIndexPrefix, String lowerIndexPrefix, boolean printMatrixIndices) {
        this.id = id;
        this.upperIndexPrefix = upperIndexPrefix;
        this.lowerIndexPrefix = lowerIndexPrefix;
        this.printMatrixIndices = printMatrixIndices;
    }

    public OutputFormat doNotPrintMatrixIndices() {
        return this.printMatrixIndices ? new OutputFormat(this, false) : this;
    }

    public OutputFormat printMatrixIndices() {
        return this.printMatrixIndices ? this : new OutputFormat(this, true);
    }

    public boolean is(OutputFormat oth) {
        return this.id == oth.id;
    }

    public String getPrefixFromIntState(int intState) {
        switch (intState) {
            case 0: {
                return this.lowerIndexPrefix;
            }
            case 1: {
                return this.upperIndexPrefix;
            }
        }
        throw new IllegalArgumentException("Not a state int");
    }

    public String getPrefixFromRawIntState(int rawIntState) {
        switch (rawIntState) {
            case 0: {
                return this.lowerIndexPrefix;
            }
            case -2147483648: {
                return this.upperIndexPrefix;
            }
        }
        throw new IllegalArgumentException("Not a state int");
    }
}

