/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.combinatorics;

import cc.redberry.core.combinatorics.IntCombinatorialGenerator;
import cc.redberry.core.combinatorics.IntCombinatorialPort;

public final class IntPermutationsGenerator
extends IntCombinatorialGenerator
implements IntCombinatorialPort {
    final int[] permutation;
    private boolean onFirst = true;
    private final int size;

    public IntPermutationsGenerator(int dimension) {
        this.permutation = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.permutation[i] = i;
        }
        this.size = dimension;
    }

    public IntPermutationsGenerator(int[] permutation) {
        this.permutation = permutation;
        this.size = permutation.length;
        for (int i = 0; i < this.size - 1; ++i) {
            if (permutation[i] >= this.size || permutation[i] < 0) {
                throw new IllegalArgumentException("Wrong permutation input: image of " + i + " element" + " greater then degree");
            }
            for (int j = i + 1; j < this.size; ++j) {
                if (permutation[i] != permutation[j]) continue;
                throw new IllegalArgumentException("Wrong permutation input: to elemets have the same image");
            }
        }
    }

    @Override
    public int[] take() {
        return this.hasNext() ? this.next() : null;
    }

    @Override
    public boolean hasNext() {
        return !this.isLast() || this.onFirst;
    }

    public boolean hasPrevious() {
        return !this.isFirst();
    }

    private boolean isLast() {
        for (int i = 0; i < this.size; ++i) {
            if (this.permutation[i] == this.size - 1 - i) continue;
            return false;
        }
        return true;
    }

    private boolean isFirst() {
        for (int i = 0; i < this.size; ++i) {
            if (this.permutation[i] == i) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] next() {
        int med;
        int high;
        int end;
        int p;
        if (this.onFirst) {
            this.onFirst = false;
            return this.permutation;
        }
        for (p = end = this.size - 1; p > 0 && this.permutation[p] < this.permutation[p - 1]; --p) {
        }
        if (p > 0) {
            int low;
            int s = this.permutation[p - 1];
            if (this.permutation[end] > s) {
                low = end;
            } else {
                high = end;
                low = p;
                while (high > low + 1) {
                    med = high + low >> 1;
                    if (this.permutation[med] < s) {
                        high = med;
                        continue;
                    }
                    low = med;
                }
            }
            this.permutation[p - 1] = this.permutation[low];
            this.permutation[low] = s;
        }
        for (high = end; high > p; ++p, --high) {
            med = this.permutation[high];
            this.permutation[high] = this.permutation[p];
            this.permutation[p] = med;
        }
        return this.permutation;
    }

    public int[] previous() {
        int m;
        int high;
        int Nm1;
        int p;
        for (p = Nm1 = this.size - 1; p > 0 && this.permutation[p] > this.permutation[p - 1]; --p) {
        }
        if (p > 0) {
            int low;
            int s = this.permutation[p - 1];
            if (this.permutation[Nm1] < s) {
                low = Nm1;
            } else {
                high = Nm1;
                low = p;
                while (high > low + 1) {
                    m = high + low >> 1;
                    if (this.permutation[m] > s) {
                        high = m;
                        continue;
                    }
                    low = m;
                }
            }
            this.permutation[p - 1] = this.permutation[low];
            this.permutation[low] = s;
        }
        for (high = Nm1; high > p; ++p, --high) {
            m = this.permutation[high];
            this.permutation[high] = this.permutation[p];
            this.permutation[p] = m;
        }
        return this.permutation;
    }

    @Override
    public void reset() {
        this.onFirst = true;
        for (int i = 0; i < this.size; ++i) {
            this.permutation[i] = i;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getDimension() {
        return this.size;
    }

    @Override
    public int[] getReference() {
        return this.permutation;
    }
}

