/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.TripleExponentialSmoothingModel;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class TripleExponentialSmoothingTest
extends OpenForecastTestCase {
    private static double TOLERANCE = 5.0E-4;

    public TripleExponentialSmoothingTest(String name) {
        super(name);
    }

    public void testConstantTripleExponentialSmoothing() {
        Observation dp;
        int NUMBER_OF_OBSERVATIONS = 20;
        DataSet observedData = new DataSet();
        for (int t = 0; t < 20; ++t) {
            dp = new Observation(5.0);
            dp.setIndependentValue("t", t + 1);
            observedData.add(dp);
        }
        observedData.setPeriodsPerYear(4);
        double[] expectedResult = new double[]{5.0, 5.0};
        double beta = 0.1;
        double gamma = 0.1;
        for (double alpha = 0.1; alpha < 0.95; alpha += 0.1) {
            TripleExponentialSmoothingModel model = new TripleExponentialSmoothingModel(alpha, gamma, beta);
            model.init(observedData);
            DataSet fcValues = new DataSet();
            dp = new Observation(0.0);
            dp.setIndependentValue("t", 19.0);
            fcValues.add(dp);
            dp = new Observation(0.0);
            dp.setIndependentValue("t", 20.0);
            fcValues.add(dp);
            DataSet results = model.forecast(fcValues);
            this.checkResults(results, expectedResult);
        }
    }

    public void testAirConditioning2YearExample() {
        Observation dp;
        DataSet observedData = new DataSet();
        double[] observations = new double[]{4.0, 3.0, 10.0, 14.0, 25.0, 26.0, 38.0, 40.0, 28.0, 17.0, 16.0, 13.0, 9.0, 6.0, 18.0, 27.0, 48.0, 50.0, 75.0, 77.0, 52.0, 33.0, 31.0, 24.0};
        for (int t = 0; t < observations.length; ++t) {
            dp = new Observation(observations[t]);
            dp.setIndependentValue("t", t - 23);
            observedData.add(dp);
        }
        observedData.setPeriodsPerYear(12);
        TripleExponentialSmoothingModel model = new TripleExponentialSmoothingModel(0.5, 0.4, 0.6);
        model.init(observedData);
        DataSet fcValues = new DataSet();
        for (int t = 0; t < 12; ++t) {
            dp = new Observation(0.0);
            dp.setIndependentValue("t", t + 1);
            fcValues.add(dp);
        }
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{10.516154, 7.65, 24.944615, 37.206923, 68.214615, 73.0, 111.057692, 118.520769, 83.618462, 53.210769, 51.268462, 41.65};
        this.checkResults(results, expectedResult, TOLERANCE);
    }

    public void testAirConditioning3YearExample() {
        Observation dp;
        DataSet observedData = new DataSet();
        double[] observations = new double[]{4.0, 3.0, 10.0, 14.0, 25.0, 26.0, 38.0, 40.0, 28.0, 17.0, 16.0, 13.0, 9.0, 6.0, 18.0, 27.0, 48.0, 50.0, 75.0, 77.0, 52.0, 33.0, 31.0, 24.0, 13.0, 7.0, 23.0, 32.0, 58.0, 60.0, 90.0, 93.0, 63.0, 39.0, 37.0, 29.0};
        for (int t = 0; t < observations.length; ++t) {
            dp = new Observation(observations[t]);
            dp.setIndependentValue("t", t - 23);
            observedData.add(dp);
        }
        observedData.setPeriodsPerYear(12);
        TripleExponentialSmoothingModel model = new TripleExponentialSmoothingModel(0.5, 0.4, 0.6);
        model.init(observedData);
        DataSet fcValues = new DataSet();
        for (int t = 0; t < 12; ++t) {
            dp = new Observation(0.0);
            dp.setIndependentValue("t", t + 1);
            fcValues.add(dp);
        }
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{10.516154, 8.875898, 25.776672, 35.482731, 59.162286, 59.736113, 86.897135, 90.762761, 62.680566, 38.729109, 36.338738, 29.0313};
        this.checkResults(results, expectedResult, TOLERANCE);
    }
}

