/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.input.TimeSeriesBuilder;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class TimeSeriesBuilderTest
extends OpenForecastTestCase {
    public void testBuilder() {
        int NUMBER_OF_TIME_PERIODS = 100;
        double[] expectedValue = new double[NUMBER_OF_TIME_PERIODS];
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Simple time series"));
        Day period = new Day();
        for (int d = 0; d < NUMBER_OF_TIME_PERIODS; ++d) {
            expectedValue[d] = d;
            timeSeries.add((RegularTimePeriod)period, (double)d);
            period = period.next();
        }
        String TIME_VARIABLE = "t";
        TimeSeriesBuilder builder = new TimeSeriesBuilder(timeSeries, TIME_VARIABLE);
        DataSet dataSet = builder.build();
        TimeSeriesBuilderTest.assertEquals((String)"DataSet created is of the wrong size", (int)NUMBER_OF_TIME_PERIODS, (int)dataSet.size());
        String[] independentVariables = dataSet.getIndependentVariables();
        TimeSeriesBuilderTest.assertEquals((String)"Checking the correct number of independent variables", (int)1, (int)independentVariables.length);
        TimeSeriesBuilderTest.assertEquals((String)"Independent variable not set as expected", (String)TIME_VARIABLE, (String)independentVariables[0]);
        this.checkResults(dataSet, expectedValue);
    }

    public TimeSeriesBuilderTest(String name) {
        super(name);
    }
}

