/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.DoubleExponentialSmoothingModel;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class DoubleExponentialSmoothingTest
extends OpenForecastTestCase {
    private static double TOLERANCE = 0.005;
    private static double MSE_TOLERANCE = 0.1;

    public DoubleExponentialSmoothingTest(String name) {
        super(name);
    }

    public void testConstantDoubleExponentialSmoothing() {
        Observation dp;
        int NUMBER_OF_OBSERVATIONS = 25;
        DataSet observedData = new DataSet();
        for (int t = 0; t < 25; ++t) {
            dp = new Observation(5.0);
            dp.setIndependentValue("t", t + 1);
            observedData.add(dp);
        }
        double[] expectedResult = new double[]{5.0, 5.0};
        double gamma = 0.1;
        for (double smoothingConstant = 0.1; smoothingConstant < 0.95; smoothingConstant += 0.1) {
            DoubleExponentialSmoothingModel model = new DoubleExponentialSmoothingModel(smoothingConstant, gamma);
            model.init(observedData);
            DataSet fcValues = new DataSet();
            dp = new Observation(0.0);
            dp.setIndependentValue("t", 24.0);
            fcValues.add(dp);
            dp = new Observation(0.0);
            dp.setIndependentValue("t", 25.0);
            fcValues.add(dp);
            DataSet results = model.forecast(fcValues);
            this.checkResults(results, expectedResult);
        }
    }

    public void testDoubleExponentialSmoothing() {
        Observation dp;
        DataSet observedData = new DataSet();
        double[] observations = new double[]{5.6, 6.4, 7.8, 8.8, 11.0, 11.6, 16.7, 15.3, 21.6, 22.4};
        for (int t = 0; t < observations.length; ++t) {
            dp = new Observation(observations[t]);
            dp.setIndependentValue("t", t + 1);
            observedData.add(dp);
        }
        DoubleExponentialSmoothingModel model = new DoubleExponentialSmoothingModel(0.3623, 1.0);
        model.init(observedData);
        DoubleExponentialSmoothingTest.assertEquals((String)"Checking the accuracy of the model", (double)3.36563849, (double)model.getMSE(), (double)MSE_TOLERANCE);
        DataSet fcValues = new DataSet();
        for (int t = 1; t <= 10; ++t) {
            dp = new Observation(0.0);
            dp.setIndependentValue("t", t);
            fcValues.add(dp);
        }
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{5.6, 6.4, 7.41738, 8.567086, 10.181699, 11.725188, 14.511845, 16.574445, 19.710524, 22.684798};
        this.checkResults(results, expectedResult, TOLERANCE);
    }
}

