/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.AbstractTimeBasedModel;

public class TripleExponentialSmoothingModel
extends AbstractTimeBasedModel {
    private static double DEFAULT_SMOOTHING_CONSTANT_TOLERANCE = 0.001;
    private static int NUMBER_OF_YEARS = 2;
    private double alpha;
    private double beta;
    private double gamma;
    private int periodsPerYear = 0;
    private double maxObservedTime;
    private DataSet baseValues;
    private DataSet trendValues;
    private DataSet seasonalIndex;

    public static TripleExponentialSmoothingModel getBestFitModel(DataSet dataSet) {
        return TripleExponentialSmoothingModel.getBestFitModel(dataSet, DEFAULT_SMOOTHING_CONSTANT_TOLERANCE, DEFAULT_SMOOTHING_CONSTANT_TOLERANCE);
    }

    public static TripleExponentialSmoothingModel getBestFitModel(DataSet dataSet, double alphaTolerance, double betaTolerance) {
        if (dataSet.size() < NUMBER_OF_YEARS * dataSet.getPeriodsPerYear()) {
            throw new IllegalArgumentException("TripleExponentialSmoothing models require a minimum of a full two years of data in the data set.");
        }
        if (alphaTolerance < 0.0 || alphaTolerance > 0.5) {
            throw new IllegalArgumentException("The value of alphaTolerance must be significantly less than 1.0, and no less than 0.0. Suggested value: " + DEFAULT_SMOOTHING_CONSTANT_TOLERANCE);
        }
        if (betaTolerance < 0.0 || betaTolerance > 0.5) {
            throw new IllegalArgumentException("The value of betaTolerance must be significantly less than 1.0, and no less than 0.0. Suggested value: " + DEFAULT_SMOOTHING_CONSTANT_TOLERANCE);
        }
        TripleExponentialSmoothingModel model1 = TripleExponentialSmoothingModel.findBestBeta(dataSet, 0.0, 0.0, 1.0, betaTolerance);
        TripleExponentialSmoothingModel model2 = TripleExponentialSmoothingModel.findBestBeta(dataSet, 0.5, 0.0, 1.0, betaTolerance);
        TripleExponentialSmoothingModel model3 = TripleExponentialSmoothingModel.findBestBeta(dataSet, 1.0, 0.0, 1.0, betaTolerance);
        TripleExponentialSmoothingModel bestModel = TripleExponentialSmoothingModel.findBest(dataSet, model1, model2, model3, alphaTolerance, betaTolerance);
        return bestModel;
    }

    private static TripleExponentialSmoothingModel findBest(DataSet dataSet, TripleExponentialSmoothingModel modelMin, TripleExponentialSmoothingModel modelMid, TripleExponentialSmoothingModel modelMax, double alphaTolerance, double betaTolerance) {
        int m;
        double alphaMin = modelMin.getAlpha();
        double alphaMid = modelMid.getAlpha();
        double alphaMax = modelMax.getAlpha();
        if (Math.abs(alphaMid - alphaMin) < alphaTolerance && Math.abs(alphaMax - alphaMid) < alphaTolerance) {
            return modelMid;
        }
        TripleExponentialSmoothingModel[] model = new TripleExponentialSmoothingModel[]{modelMin, TripleExponentialSmoothingModel.findBestBeta(dataSet, (alphaMin + alphaMid) / 2.0, 0.0, 1.0, betaTolerance), modelMid, TripleExponentialSmoothingModel.findBestBeta(dataSet, (alphaMid + alphaMax) / 2.0, 0.0, 1.0, betaTolerance), modelMax};
        for (int m2 = 0; m2 < 5; ++m2) {
            model[m2].init(dataSet);
        }
        int bestModelIndex = 0;
        for (m = 1; m < 5; ++m) {
            if (!(model[m].getMSE() < model[bestModelIndex].getMSE())) continue;
            bestModelIndex = m;
        }
        switch (bestModelIndex) {
            case 1: {
                model[3] = null;
                model[4] = null;
                return TripleExponentialSmoothingModel.findBest(dataSet, model[0], model[1], model[2], alphaTolerance, betaTolerance);
            }
            case 2: {
                model[0] = null;
                model[4] = null;
                return TripleExponentialSmoothingModel.findBest(dataSet, model[1], model[2], model[3], alphaTolerance, betaTolerance);
            }
            case 3: {
                model[0] = null;
                model[1] = null;
                return TripleExponentialSmoothingModel.findBest(dataSet, model[2], model[3], model[4], alphaTolerance, betaTolerance);
            }
        }
        for (m = 0; m < 5; ++m) {
            if (m == bestModelIndex) continue;
            model[m] = null;
        }
        return model[bestModelIndex];
    }

    private static TripleExponentialSmoothingModel findBestBeta(DataSet dataSet, double alpha, double betaMin, double betaMax, double betaTolerance) {
        int stepsPerIteration = 10;
        if (betaMin < 0.0) {
            betaMin = 0.0;
        }
        if (betaMax > 1.0) {
            betaMax = 1.0;
        }
        TripleExponentialSmoothingModel bestModel = new TripleExponentialSmoothingModel(alpha, betaMin, 0.0);
        bestModel.init(dataSet);
        double initialMSE = bestModel.getMSE();
        boolean betaImproving = true;
        double betaStep = (betaMax - betaMin) / (double)stepsPerIteration;
        double beta = betaMin + betaStep;
        while (beta <= betaMax || betaImproving) {
            TripleExponentialSmoothingModel model = new TripleExponentialSmoothingModel(alpha, beta, 0.0);
            model.init(dataSet);
            if (model.getMSE() < bestModel.getMSE()) {
                bestModel = model;
            } else {
                betaImproving = false;
            }
            if (!((beta += betaStep) > 1.0)) continue;
            betaImproving = false;
        }
        if (bestModel.getMSE() < initialMSE && betaStep > betaTolerance) {
            return TripleExponentialSmoothingModel.findBestBeta(dataSet, bestModel.getAlpha(), bestModel.getBeta() - betaStep, bestModel.getBeta() + betaStep, betaTolerance);
        }
        return bestModel;
    }

    public TripleExponentialSmoothingModel(double alpha, double beta, double gamma) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("TripleExponentialSmoothingModel: Invalid smoothing constant, " + alpha + " - must be in the range 0.0-1.0.");
        }
        if (beta < 0.0 || beta > 1.0) {
            throw new IllegalArgumentException("TripleExponentialSmoothingModel: Invalid smoothing constant, beta=" + beta + " - must be in the range 0.0-1.0.");
        }
        if (gamma < 0.0 || gamma > 1.0) {
            throw new IllegalArgumentException("TripleExponentialSmoothingModel: Invalid smoothing constant, gamma=" + gamma + " - must be in the range 0.0-1.0.");
        }
        this.baseValues = new DataSet();
        this.trendValues = new DataSet();
        this.seasonalIndex = new DataSet();
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = gamma;
    }

    @Override
    public void init(DataSet dataSet) {
        this.initTimeVariable(dataSet);
        String timeVariable = this.getTimeVariable();
        if (dataSet.getPeriodsPerYear() <= 1) {
            throw new IllegalArgumentException("Data set passed to init in the triple exponential smoothing model does not contain seasonal data. Don't forget to call setPeriodsPerYear on the data set to set this.");
        }
        this.periodsPerYear = dataSet.getPeriodsPerYear();
        if (dataSet.size() < NUMBER_OF_YEARS * this.periodsPerYear) {
            throw new IllegalArgumentException("TripleExponentialSmoothing models require a minimum of a full two years of data to initialize the model.");
        }
        this.initBaseAndTrendValues(dataSet);
        this.initSeasonalIndices(dataSet);
        Iterator<DataPoint> it = dataSet.iterator();
        this.maxObservedTime = Double.NEGATIVE_INFINITY;
        while (it.hasNext()) {
            DataPoint dp = it.next();
            if (!(dp.getIndependentValue(timeVariable) > this.maxObservedTime)) continue;
            this.maxObservedTime = dp.getIndependentValue(timeVariable);
        }
        super.init(dataSet);
    }

    private void initBaseAndTrendValues(DataSet dataSet) {
        int p;
        String timeVariable = this.getTimeVariable();
        double trend = 0.0;
        Iterator<DataPoint> it = dataSet.iterator();
        for (int p2 = 0; p2 < this.periodsPerYear; ++p2) {
            DataPoint dp = it.next();
            trend -= dp.getDependentValue();
        }
        double year2Average = 0.0;
        for (p = 0; p < this.periodsPerYear; ++p) {
            DataPoint dp = it.next();
            trend += dp.getDependentValue();
            year2Average += dp.getDependentValue();
        }
        trend /= (double)this.periodsPerYear;
        trend /= (double)this.periodsPerYear;
        year2Average /= (double)this.periodsPerYear;
        it = dataSet.iterator();
        for (p = 0; p < this.periodsPerYear * NUMBER_OF_YEARS; ++p) {
            DataPoint obs = it.next();
            double time = obs.getIndependentValue(timeVariable);
            Observation dp = new Observation(trend);
            dp.setIndependentValue(timeVariable, time);
            this.trendValues.add(dp);
            if (p < this.periodsPerYear) continue;
            dp.setDependentValue(year2Average + ((double)(p + 1 - this.periodsPerYear) - (double)(this.periodsPerYear + 1) / 2.0) * trend);
            this.baseValues.add(dp);
        }
    }

    private void initSeasonalIndices(DataSet dataSet) {
        int p;
        int year;
        String timeVariable = this.getTimeVariable();
        double[] yearlyAverage = new double[NUMBER_OF_YEARS];
        Iterator<DataPoint> it = dataSet.iterator();
        for (int year2 = 0; year2 < NUMBER_OF_YEARS; ++year2) {
            double sum = 0.0;
            for (int p2 = 0; p2 < this.periodsPerYear; ++p2) {
                DataPoint dp = it.next();
                sum += dp.getDependentValue();
            }
            yearlyAverage[year2] = sum / (double)this.periodsPerYear;
        }
        it = dataSet.iterator();
        double[] index = new double[this.periodsPerYear];
        for (year = 0; year < NUMBER_OF_YEARS; ++year) {
            p = 0;
            while (p < this.periodsPerYear) {
                DataPoint dp = it.next();
                int n = p++;
                index[n] = index[n] + dp.getDependentValue() / yearlyAverage[year] / (double)NUMBER_OF_YEARS;
            }
        }
        it = dataSet.iterator();
        for (year = 0; year < NUMBER_OF_YEARS - 1; ++year) {
            for (p = 0; p < this.periodsPerYear; ++p) {
                it.next();
            }
        }
        for (int p3 = 0; p3 < this.periodsPerYear; ++p3) {
            DataPoint dp = it.next();
            double time = dp.getIndependentValue(timeVariable);
            Observation obs = new Observation(index[p3]);
            obs.setIndependentValue(timeVariable, time);
            this.seasonalIndex.add(obs);
        }
    }

    @Override
    protected double forecast(double time) throws IllegalArgumentException {
        double previousTime = time - this.getTimeInterval();
        double previousYear = time - this.getTimeInterval() * (double)this.periodsPerYear;
        if (previousTime < this.getMinimumTimeValue() - TOLERANCE) {
            return this.getObservedValue(time);
        }
        try {
            double base = this.getBase(previousTime);
            double trend = this.getTrend(previousTime);
            double si = this.getSeasonalIndex(previousYear);
            double forecast = (base + trend) * si;
            return forecast;
        }
        catch (IllegalArgumentException idex) {
            double base = this.getBase(this.maxObservedTime);
            double trend = this.getTrend(this.maxObservedTime - this.getTimeInterval());
            double si = this.getSeasonalIndex(previousYear);
            double forecast = (base + (time - this.maxObservedTime) * trend) * si;
            return forecast;
        }
    }

    private double getBase(double time) throws IllegalArgumentException {
        String timeVariable = this.getTimeVariable();
        for (DataPoint dp : this.baseValues) {
            double dpTimeValue = dp.getIndependentValue(timeVariable);
            if (!(Math.abs(time - dpTimeValue) < TOLERANCE)) continue;
            return dp.getDependentValue();
        }
        if (time < this.getMinimumTimeValue() + (double)this.periodsPerYear * this.getTimeInterval() + TOLERANCE) {
            throw new IllegalArgumentException("Attempt to forecast for an invalid time " + time + " - before sufficient observations were made (" + this.getMinimumTimeValue() + (double)this.periodsPerYear * this.getTimeInterval() + ").");
        }
        double previousTime = time - this.getTimeInterval();
        double previousYear = time - (double)this.periodsPerYear * this.getTimeInterval();
        double base = this.alpha * (this.getObservedValue(time) / this.getSeasonalIndex(previousYear)) + (1.0 - this.alpha) * (this.getBase(previousTime) + this.getTrend(previousTime));
        Observation dp = new Observation(base);
        dp.setIndependentValue(timeVariable, time);
        this.baseValues.add(dp);
        return base;
    }

    private double getTrend(double time) throws IllegalArgumentException {
        String timeVariable = this.getTimeVariable();
        for (DataPoint dp : this.trendValues) {
            double dpTimeValue = dp.getIndependentValue(timeVariable);
            if (!(Math.abs(time - dpTimeValue) < TOLERANCE)) continue;
            return dp.getDependentValue();
        }
        if (time < this.getMinimumTimeValue() + TOLERANCE) {
            throw new IllegalArgumentException("Attempt to forecast for an invalid time - before the observations began (" + this.getMinimumTimeValue() + ").");
        }
        double previousTime = time - this.getTimeInterval();
        double trend = this.beta * (this.getBase(time) - this.getBase(previousTime)) + (1.0 - this.beta) * this.getTrend(previousTime);
        Observation dp = new Observation(trend);
        dp.setIndependentValue(timeVariable, time);
        this.trendValues.add(dp);
        return trend;
    }

    private double getSeasonalIndex(double time) throws IllegalArgumentException {
        if (time < this.getMinimumTimeValue() + (double)((NUMBER_OF_YEARS - 1) * this.periodsPerYear) - TOLERANCE) {
            return this.getSeasonalIndex(time + (double)this.periodsPerYear * this.getTimeInterval());
        }
        String timeVariable = this.getTimeVariable();
        for (DataPoint dp : this.seasonalIndex) {
            double dpTimeValue = dp.getIndependentValue(timeVariable);
            if (!(Math.abs(time - dpTimeValue) < TOLERANCE)) continue;
            return dp.getDependentValue();
        }
        double previousYear = time - this.getTimeInterval() * (double)this.periodsPerYear;
        double index = this.gamma * (this.getObservedValue(time) / this.getForecastValue(time)) + (1.0 - this.gamma) * this.getSeasonalIndex(previousYear);
        Observation dp = new Observation(index);
        dp.setIndependentValue(timeVariable, time);
        this.seasonalIndex.add(dp);
        return index;
    }

    @Override
    public int getNumberOfPredictors() {
        return 1;
    }

    @Override
    protected int getNumberOfPeriods() {
        return 2 * this.periodsPerYear;
    }

    @Override
    protected void calculateAccuracyIndicators(DataSet dataSet) {
        this.initialized = true;
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumAbsPercentErr = 0.0;
        double sumErrSquared = 0.0;
        String timeVariable = this.getTimeVariable();
        double timeDiff = this.getTimeInterval();
        for (DataPoint dp : dataSet) {
            double x = dp.getDependentValue();
            double time = dp.getIndependentValue(timeVariable);
            double previousTime = time - timeDiff;
            double forecastValue = this.getForecastValue(previousTime) + this.getTrend(previousTime);
            double error = forecastValue - x;
            sumErr += error;
            sumAbsErr += Math.abs(error);
            sumAbsPercentErr += Math.abs(error / x);
            sumErrSquared += error * error;
        }
        int n = dataSet.size();
        this.accuracyIndicators.setBias(sumErr / (double)n);
        this.accuracyIndicators.setMAD(sumAbsErr / (double)n);
        this.accuracyIndicators.setMAPE(sumAbsPercentErr / (double)n);
        this.accuracyIndicators.setMSE(sumErrSquared / (double)n);
        this.accuracyIndicators.setSAE(sumAbsErr);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    @Override
    public String getForecastType() {
        return "triple exponential smoothing";
    }

    @Override
    public String toString() {
        return "Triple exponential smoothing model, with smoothing constants of alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + ", and using an independent variable of " + this.getIndependentVariable();
    }
}

