/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.models.AccuracyIndicators;
import net.sourceforge.openforecast.models.ModelNotInitializedException;

public abstract class AbstractForecastingModel
implements ForecastingModel {
    static double TOLERANCE = 1.0E-8;
    protected AccuracyIndicators accuracyIndicators = new AccuracyIndicators();
    protected boolean initialized = false;

    protected AbstractForecastingModel() {
    }

    @Override
    public double getAIC() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getAIC();
    }

    @Override
    public double getBias() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getBias();
    }

    @Override
    public double getMAD() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getMAD();
    }

    @Override
    public double getMAPE() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getMAPE();
    }

    @Override
    public double getMSE() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getMSE();
    }

    @Override
    public double getSAE() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getSAE();
    }

    @Override
    public DataSet forecast(DataSet dataSet) {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        for (DataPoint dp : dataSet) {
            dp.setDependentValue(this.forecast(dp));
        }
        return dataSet;
    }

    protected void calculateAccuracyIndicators(DataSet dataSet) {
        this.initialized = true;
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumAbsPercentErr = 0.0;
        double sumErrSquared = 0.0;
        DataSet forecastValues = new DataSet(dataSet);
        this.forecast(forecastValues);
        Iterator<DataPoint> it = dataSet.iterator();
        Iterator<DataPoint> itForecast = forecastValues.iterator();
        while (it.hasNext()) {
            DataPoint dp = it.next();
            double x = dp.getDependentValue();
            DataPoint dpForecast = itForecast.next();
            double forecastValue = dpForecast.getDependentValue();
            double error = forecastValue - x;
            sumErr += error;
            sumAbsErr += Math.abs(error);
            sumAbsPercentErr += Math.abs(error / x);
            sumErrSquared += error * error;
        }
        int n = dataSet.size();
        int p = this.getNumberOfPredictors();
        this.accuracyIndicators.setAIC((double)n * Math.log(Math.PI * 2) + Math.log(sumErrSquared / (double)n) + (double)(2 * (p + 2)));
        this.accuracyIndicators.setBias(sumErr / (double)n);
        this.accuracyIndicators.setMAD(sumAbsErr / (double)n);
        this.accuracyIndicators.setMAPE(sumAbsPercentErr / (double)n);
        this.accuracyIndicators.setMSE(sumErrSquared / (double)n);
        this.accuracyIndicators.setSAE(sumAbsErr);
    }
}

