/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.timeseries.HistoricalSimulationModel;

public class SimpleHistroricalSimulation
implements HistoricalSimulationModel {
    private double[] values;
    private int windowIndexStart;
    private int windowIndexEnd;

    public SimpleHistroricalSimulation(double[] dArray) {
        this.values = dArray;
        this.windowIndexStart = 0;
        this.windowIndexEnd = dArray.length - 1;
    }

    public SimpleHistroricalSimulation(double[] dArray, int n, int n2) {
        this.values = dArray;
        this.windowIndexStart = n;
        this.windowIndexEnd = n2;
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int n, int n2) {
        return new SimpleHistroricalSimulation(this.values, n, n2);
    }

    public double[] getSzenarios(int n) {
        double[] dArray = new double[this.windowIndexEnd - this.windowIndexStart + 1 - 1];
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double d = n == 1 ? Math.log(this.values[i] / this.values[i - 1]) : this.values[i] - this.values[i - 1];
            dArray[i - this.windowIndexStart - 1] = d;
        }
        Arrays.sort(dArray);
        return dArray;
    }

    public double[] getQuantilPredictions(int n, double[] dArray) {
        double[] dArray2 = this.getSzenarios(n);
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d;
            double d2;
            double d3 = dArray[i];
            double d4 = (double)dArray2.length * d3 - 1.0;
            int n2 = (int)d4;
            int n3 = n2 + 1;
            double d5 = dArray2[Math.max(n2, 0)];
            double d6 = dArray2[Math.max(n3, 0)];
            if (n == 1) {
                d2 = ((double)n3 - d4) * Math.exp(d5) + (d4 - (double)n2) * Math.exp(d6);
                dArray3[i] = d = this.values[this.windowIndexEnd] * d2;
                continue;
            }
            d2 = ((double)n3 - d4) * d5 + (d4 - (double)n2) * d6;
            dArray3[i] = d = this.values[this.windowIndexEnd] + d2;
        }
        return dArray3;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> map) {
        int n = 1;
        double[] dArray = new double[]{0.01, 0.05, 0.5};
        double[] dArray2 = this.getQuantilPredictions(n, dArray);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Szenarios", this.getSzenarios(n));
        hashMap.put("Quantile=1%", dArray2[0]);
        hashMap.put("Quantile=5%", dArray2[1]);
        hashMap.put("Quantile=50%", dArray2[2]);
        return hashMap;
    }
}

