/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.util.Calendar;
import java.util.GregorianCalendar;
import net.finmath.time.daycount.DayCountConvention_30E_360_ISDA;
import org.junit.Assert;
import org.junit.Test;

public class DayCountConvention_30E_360_ISDATest {
    private static Calendar[] startDates = new Calendar[]{new GregorianCalendar(2007, 0, 15), new GregorianCalendar(2007, 0, 15), new GregorianCalendar(2007, 0, 15), new GregorianCalendar(2007, 8, 30), new GregorianCalendar(2007, 8, 30), new GregorianCalendar(2007, 8, 30), new GregorianCalendar(2007, 0, 15), new GregorianCalendar(2007, 0, 31), new GregorianCalendar(2007, 1, 28), new GregorianCalendar(2006, 7, 31), new GregorianCalendar(2007, 1, 28), new GregorianCalendar(2007, 1, 14), new GregorianCalendar(2007, 1, 26), new GregorianCalendar(2008, 1, 29), new GregorianCalendar(2008, 1, 29), new GregorianCalendar(2008, 1, 29), new GregorianCalendar(2007, 1, 28), new GregorianCalendar(2007, 9, 31), new GregorianCalendar(2007, 7, 31), new GregorianCalendar(2008, 1, 29), new GregorianCalendar(2008, 7, 31), new GregorianCalendar(2009, 1, 28)};
    private static Calendar[] endDates = new Calendar[]{new GregorianCalendar(2007, 0, 30), new GregorianCalendar(2007, 1, 15), new GregorianCalendar(2007, 6, 15), new GregorianCalendar(2008, 2, 31), new GregorianCalendar(2007, 9, 31), new GregorianCalendar(2008, 8, 30), new GregorianCalendar(2007, 0, 31), new GregorianCalendar(2007, 1, 28), new GregorianCalendar(2007, 2, 31), new GregorianCalendar(2007, 1, 28), new GregorianCalendar(2007, 7, 31), new GregorianCalendar(2007, 1, 28), new GregorianCalendar(2008, 1, 29), new GregorianCalendar(2009, 1, 28), new GregorianCalendar(2008, 2, 30), new GregorianCalendar(2008, 2, 31), new GregorianCalendar(2007, 2, 5), new GregorianCalendar(2007, 10, 28), new GregorianCalendar(2008, 1, 29), new GregorianCalendar(2008, 7, 31), new GregorianCalendar(2009, 1, 28), new GregorianCalendar(2009, 7, 31)};
    double[] daycountFractionsIfEndDateIsNotTerminationDate = new double[]{0.0416666667, 0.0833333333, 0.5, 0.5, 0.0833333333, 1.0, 0.0416666667, 0.0833333333, 0.0833333333, 0.5, 0.5, 0.0444444444, 1.0111111111, 1.0, 0.0833333333, 0.0833333333, 0.0138888889, 0.0777777778, 0.5, 0.5, 0.5, 0.5};
    double[] daycountFractionsIfEndDateIsTerminationDate = new double[]{0.0416666667, 0.0833333333, 0.5, 0.5, 0.0833333333, 1.0, 0.0416666667, 0.07777777774444446, 0.0833333333, 0.49444444444444446, 0.5, 0.03888888884444444, 1.0083333333222222, 0.9944444444, 0.0833333333, 0.0833333333, 0.0138888889, 0.0777777778, 0.49722222222222223, 0.5, 0.4944444444, 0.5};

    @Test
    public void testAssumingEndDateIsNotATerminationDate() {
        DayCountConvention_30E_360_ISDA dayCountConvention_30E_360_ISDA = new DayCountConvention_30E_360_ISDA(false);
        for (int i = 0; i < startDates.length; ++i) {
            String string = "Test " + i + " of daycountFraction(" + startDates[i].getTime() + "," + endDates[i].getTime() + ",30E360)";
            double d = dayCountConvention_30E_360_ISDA.getDaycountFraction(startDates[i], endDates[i]) - this.daycountFractionsIfEndDateIsNotTerminationDate[i];
            Assert.assertEquals((String)string, (double)0.0, (double)d, (double)1.0E-10);
        }
    }

    @Test
    public void testAssumingEndDateIsATerminationDate() {
        DayCountConvention_30E_360_ISDA dayCountConvention_30E_360_ISDA = new DayCountConvention_30E_360_ISDA(true);
        for (int i = 0; i < startDates.length; ++i) {
            String string = "Test " + i + " of daycountFraction(" + startDates[i].getTime() + "," + endDates[i].getTime() + ",30E360)";
            double d = dayCountConvention_30E_360_ISDA.getDaycountFraction(startDates[i], endDates[i]) - this.daycountFractionsIfEndDateIsTerminationDate[i];
            Assert.assertEquals((String)string, (double)0.0, (double)d, (double)1.0E-10);
        }
    }
}

