/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.rootfinder.RootFinder;

public class SecantMethod
extends NewtonsMethod
implements RootFinder {
    private final double secondGuess;
    private double currentPoint;
    private double lastPoint;
    private double lastValue;

    public SecantMethod(double d, double d2) {
        super(d);
        this.secondGuess = d2;
    }

    @Override
    public double getNextPoint() {
        this.currentPoint = super.getNextPoint();
        return this.currentPoint;
    }

    @Override
    public void setValue(double d) {
        double d2 = this.getNumberOfIterations() == 0 ? d / (this.secondGuess - this.currentPoint) : (d - this.lastValue) / (this.currentPoint - this.lastPoint);
        this.lastPoint = this.currentPoint;
        this.lastValue = d;
        super.setValueAndDerivative(d, d2);
    }

    @Override
    public void setValueAndDerivative(double d, double d2) {
        this.lastPoint = super.getNextPoint();
        this.lastValue = d;
        super.setValueAndDerivative(d, d2);
    }
}

