/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class PerformanceIndex
extends AbstractIndex {
    private static final long serialVersionUID = -8181742829635380940L;
    private AbstractProductComponent numeratorIndex;
    private AbstractProductComponent denominatorIndex;

    public PerformanceIndex(AbstractProductComponent abstractProductComponent, AbstractProductComponent abstractProductComponent2) {
        this.numeratorIndex = abstractProductComponent;
        this.denominatorIndex = abstractProductComponent2;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        return this.numeratorIndex.getValue(d, lIBORModelMonteCarloSimulationInterface).div(this.denominatorIndex.getValue(d, lIBORModelMonteCarloSimulationInterface));
    }

    public AbstractProductComponent getNumeratorIndex() {
        return this.numeratorIndex;
    }

    public AbstractProductComponent getDenominatorIndex() {
        return this.denominatorIndex;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set = this.numeratorIndex.queryUnderlyings();
        Set<String> set2 = this.denominatorIndex.queryUnderlyings();
        if (set2 != null) {
            if (set != null) {
                set.addAll(set2);
            } else {
                set = set2;
            }
        }
        return set;
    }
}

