/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Arrays;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class MaxIndex
extends AbstractIndex {
    private static final long serialVersionUID = -1512137372132830198L;
    private final AbstractProductComponent[] indexArguments;

    public MaxIndex(AbstractProductComponent ... abstractProductComponentArray) {
        if (abstractProductComponentArray.length < 1) {
            throw new IllegalArgumentException("Missing arguments. Please provide one or more arguments.");
        }
        this.indexArguments = abstractProductComponentArray;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.indexArguments[0].getValue(d, lIBORModelMonteCarloSimulationInterface);
        for (AbstractProductComponent abstractProductComponent : this.indexArguments) {
            randomVariableInterface = randomVariableInterface.floor(abstractProductComponent.getValue(d, lIBORModelMonteCarloSimulationInterface));
        }
        return randomVariableInterface;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set = null;
        for (AbstractProductComponent abstractProductComponent : this.indexArguments) {
            Set<String> set2 = abstractProductComponent.queryUnderlyings();
            if (set2 == null) continue;
            if (set == null) {
                set = set2;
                continue;
            }
            set.addAll(set2);
        }
        return set;
    }

    @Override
    public String toString() {
        return "MaxIndex [indexArguments=" + Arrays.toString(this.indexArguments) + "]";
    }
}

