/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.AnalyticModelIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class AccrualAccount
extends AbstractProductComponent {
    private static final long serialVersionUID = 188297603697240319L;
    private AnalyticModelIndex pastFixings = null;
    private AbstractIndex accrualIndex;
    private double accrualPeriod;

    public AccrualAccount(String string, AnalyticModelIndex analyticModelIndex, AbstractIndex abstractIndex, double d) {
        super(string);
        this.pastFixings = analyticModelIndex;
        this.accrualIndex = abstractIndex;
        this.accrualPeriod = d;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.accrualIndex.queryUnderlyings();
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        if (d <= 0.0) {
            return this.pastFixings.getValue(d, lIBORModelMonteCarloSimulationInterface);
        }
        RandomVariableInterface randomVariableInterface = this.pastFixings.getValue(0.0, lIBORModelMonteCarloSimulationInterface);
        for (double d2 = 0.0; d2 < d; d2 += this.accrualPeriod) {
            RandomVariableInterface randomVariableInterface2 = this.accrualIndex.getValue(d2, lIBORModelMonteCarloSimulationInterface);
            double d3 = Math.min(this.accrualPeriod, d - d2);
            randomVariableInterface = randomVariableInterface.accrue(randomVariableInterface2, d3);
        }
        return randomVariableInterface;
    }
}

