/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SimpleSwap;
import net.finmath.montecarlo.interestrate.products.SwapLeg;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.ScheduleInterface;

public class Swap
extends AbstractLIBORMonteCarloProduct {
    private final AbstractLIBORMonteCarloProduct legReceiver;
    private final AbstractLIBORMonteCarloProduct legPayer;

    public Swap(AbstractNotional abstractNotional, ScheduleInterface scheduleInterface, AbstractIndex abstractIndex, double d, ScheduleInterface scheduleInterface2, AbstractIndex abstractIndex2, double d2) {
        this.legReceiver = new SwapLeg(scheduleInterface, abstractNotional, abstractIndex, d, false);
        this.legPayer = new SwapLeg(scheduleInterface2, abstractNotional, abstractIndex2, d2, false);
    }

    public Swap(double[] dArray, double[] dArray2, double[] dArray3) {
        this.legReceiver = new SimpleSwap(dArray, dArray2, dArray3);
        this.legPayer = null;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.legReceiver.getValue(d, lIBORModelMonteCarloSimulationInterface);
        if (this.legPayer != null) {
            randomVariableInterface = randomVariableInterface.sub(this.legPayer.getValue(d, lIBORModelMonteCarloSimulationInterface));
        }
        return randomVariableInterface;
    }
}

