/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Portfolio
extends AbstractProductComponent {
    private static final long serialVersionUID = -1360506093081238482L;
    private AbstractLIBORMonteCarloProduct[] products;
    private double[] weights;

    public Portfolio(AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct, double d) {
        super(abstractLIBORMonteCarloProduct.getCurrency());
        this.products = new AbstractLIBORMonteCarloProduct[]{abstractLIBORMonteCarloProduct};
        this.weights = new double[]{d};
    }

    public Portfolio(AbstractLIBORMonteCarloProduct[] abstractLIBORMonteCarloProductArray, double[] dArray) {
        String string = abstractLIBORMonteCarloProductArray[0].getCurrency();
        for (AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct : abstractLIBORMonteCarloProductArray) {
            if (string.equals(abstractLIBORMonteCarloProduct.getCurrency())) continue;
            throw new IllegalArgumentException("Product currencies do not match. Please use a constructor providing the currency of the result.");
        }
        this.products = abstractLIBORMonteCarloProductArray;
        this.weights = dArray;
    }

    public Portfolio(String string, AbstractLIBORMonteCarloProduct[] abstractLIBORMonteCarloProductArray, double[] dArray) {
        super(string);
        for (AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct : abstractLIBORMonteCarloProductArray) {
            if (string.equals(abstractLIBORMonteCarloProduct.getCurrency())) continue;
            throw new IllegalArgumentException("Product currencies do not match. Currency conversion (via model FX) is not supported yet.");
        }
        this.products = abstractLIBORMonteCarloProductArray;
        this.weights = dArray;
    }

    @Override
    public String getCurrency() {
        return this.products != null && this.products.length > 0 ? this.products[0].getCurrency() : null;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set = null;
        for (AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct : this.products) {
            if (!(abstractLIBORMonteCarloProduct instanceof AbstractProductComponent)) {
                throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
            }
            Set<String> set2 = ((AbstractProductComponent)abstractLIBORMonteCarloProduct).queryUnderlyings();
            if (set2 == null) continue;
            if (set == null) {
                set = set2;
                continue;
            }
            set.addAll(set2);
        }
        return set;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0);
        for (int i = 0; i < this.products.length; ++i) {
            RandomVariableInterface randomVariableInterface2 = this.products[i].getValue(d, lIBORModelMonteCarloSimulationInterface);
            double d2 = this.weights[i];
            randomVariableInterface = randomVariableInterface.addProduct(randomVariableInterface2, d2);
        }
        return randomVariableInterface;
    }

    public AbstractLIBORMonteCarloProduct[] getProducts() {
        return (AbstractLIBORMonteCarloProduct[])this.products.clone();
    }

    public double[] getWeights() {
        return (double[])this.weights.clone();
    }
}

