/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class Caplet
extends AbstractLIBORMonteCarloProduct {
    private final double maturity;
    private final double periodLength;
    private final double strike;
    private final boolean isFloorlet;

    public Caplet(double d, double d2, double d3, boolean bl) {
        this.maturity = d;
        this.periodLength = d2;
        this.strike = d3;
        this.isFloorlet = bl;
    }

    public Caplet(double d, double d2, double d3) {
        this(d, d2, d3, false);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d2 = this.maturity + this.periodLength;
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getLIBOR(this.maturity, this.maturity, this.maturity + this.periodLength);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d2);
        RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(lIBORModelMonteCarloSimulationInterface.getTimeIndex(d2));
        RandomVariableInterface randomVariableInterface4 = randomVariableInterface;
        randomVariableInterface4 = !this.isFloorlet ? randomVariableInterface4.sub(this.strike).floor(0.0).mult(this.periodLength) : randomVariableInterface4.sub(this.strike).cap(0.0).mult(-1.0 * this.periodLength);
        randomVariableInterface4 = randomVariableInterface4.div(randomVariableInterface2).mult(randomVariableInterface3);
        RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface6 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface4 = randomVariableInterface4.mult(randomVariableInterface5).div(randomVariableInterface6);
        return randomVariableInterface4;
    }
}

