/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelTwoParameterExponentialForm
extends LIBORVolatilityModel {
    private double a;
    private double b;
    private boolean isCalibrateable = false;

    public LIBORVolatilityModelTwoParameterExponentialForm(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double d, double d2) {
        this(timeDiscretizationInterface, timeDiscretizationInterface2, d, d2, true);
    }

    public LIBORVolatilityModelTwoParameterExponentialForm(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double d, double d2, boolean bl) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.a = d;
        this.b = d2;
        this.isCalibrateable = bl;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] dArray = new double[]{this.a, this.b};
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = dArray[0];
        this.b = dArray[1];
    }

    @Override
    public RandomVariable getVolatility(int n, int n2) {
        double d = this.getTimeDiscretization().getTime(n);
        double d2 = this.getLiborPeriodDiscretization().getTime(n2);
        double d3 = d2 - d;
        double d4 = d3 <= 0.0 ? 0.0 : this.a * Math.exp(-this.b * d3);
        return new RandomVariable(this.getTimeDiscretization().getTime(n), d4);
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelTwoParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.a, this.b, this.isCalibrateable);
    }
}

