/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloMultiAssetBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.EuropeanOption;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;

public class ModelFactory {
    private static ModelFactory modelFactory;

    private ModelFactory() {
    }

    public static synchronized ModelFactory getInstance() {
        if (modelFactory == null) {
            modelFactory = new ModelFactory();
        }
        return modelFactory;
    }

    public HybridAssetLIBORModelMonteCarloSimulationInterface getHybridAssetLIBORModel(final LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface, final BrownianMotionInterface brownianMotionInterface, final double[] dArray, final double d, final double[][] dArray2, final double[] dArray3, final double[] dArray4, double[] dArray5, DiscountCurveInterface discountCurveInterface) throws CalculationException {
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(dArray5, dArray5, 100, 1){
            private static final long serialVersionUID = -9199565564991442848L;

            @Override
            public void setValues(double[] dArray5, double[] dArray22) throws SolverException {
                MonteCarloMultiAssetBlackScholesModel monteCarloMultiAssetBlackScholesModel = new MonteCarloMultiAssetBlackScholesModel(brownianMotionInterface, dArray, d, dArray5, dArray2);
                HybridAssetLIBORModelMonteCarloSimulation hybridAssetLIBORModelMonteCarloSimulation = new HybridAssetLIBORModelMonteCarloSimulation(lIBORModelMonteCarloSimulationInterface, monteCarloMultiAssetBlackScholesModel);
                try {
                    for (int i = 0; i < dArray22.length; ++i) {
                        double d5;
                        double d2 = hybridAssetLIBORModelMonteCarloSimulation.getNumeraire(dArray3[i]).invert().getAverage();
                        double d3 = hybridAssetLIBORModelMonteCarloSimulation.getAssetValue(0.0, i).getAverage();
                        EuropeanOption europeanOption = new EuropeanOption(dArray3[i], dArray4[i], i);
                        double d4 = europeanOption.getValue(hybridAssetLIBORModelMonteCarloSimulation);
                        dArray22[i] = d5 = AnalyticFormulas.blackScholesOptionImpliedVolatility(d3 / d2, dArray3[i], dArray4[i], d2, d4);
                    }
                }
                catch (CalculationException calculationException) {
                    throw new SolverException(calculationException);
                }
            }
        };
        try {
            levenbergMarquardt.run();
        }
        catch (SolverException solverException) {
            if (solverException.getCause() instanceof CalculationException) {
                throw (CalculationException)solverException.getCause();
            }
            throw new CalculationException(solverException);
        }
        MonteCarloMultiAssetBlackScholesModel monteCarloMultiAssetBlackScholesModel = new MonteCarloMultiAssetBlackScholesModel(brownianMotionInterface, dArray, d, levenbergMarquardt.getBestFitParameters(), dArray2);
        HybridAssetLIBORModelMonteCarloSimulation hybridAssetLIBORModelMonteCarloSimulation = new HybridAssetLIBORModelMonteCarloSimulation(lIBORModelMonteCarloSimulationInterface, monteCarloMultiAssetBlackScholesModel, null);
        for (int i = 0; i < dArray5.length; ++i) {
            EuropeanOption europeanOption;
            double d2;
            double d3 = hybridAssetLIBORModelMonteCarloSimulation.getNumeraire(dArray3[i]).invert().getAverage();
            double d4 = hybridAssetLIBORModelMonteCarloSimulation.getAssetValue(0.0, i).getAverage();
            double d5 = AnalyticFormulas.blackScholesOptionImpliedVolatility(d4 / d3, dArray3[i], dArray4[i], d3, d2 = (europeanOption = new EuropeanOption(dArray3[i], dArray4[i], i)).getValue(hybridAssetLIBORModelMonteCarloSimulation));
            if (!(Math.abs(d5 - dArray5[i]) > 0.01)) continue;
            throw new CalculationException("Calibration failed");
        }
        HybridAssetLIBORModelMonteCarloSimulation hybridAssetLIBORModelMonteCarloSimulation2 = new HybridAssetLIBORModelMonteCarloSimulation(lIBORModelMonteCarloSimulationInterface, monteCarloMultiAssetBlackScholesModel, discountCurveInterface);
        return hybridAssetLIBORModelMonteCarloSimulation2;
    }
}

