/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class BlackScholesHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double riskFreeRate;
    private final double volatility;
    private final double hedgeOptionMaturity;
    private final double hedgeOptionStrike;
    private final HedgeStrategy hedgeStrategy;

    public BlackScholesHedgedPortfolio(double d, double d2, double d3, double d4) {
        this.maturity = d;
        this.strike = d2;
        this.riskFreeRate = d3;
        this.volatility = d4;
        this.hedgeOptionMaturity = 0.0;
        this.hedgeOptionStrike = 0.0;
        this.hedgeStrategy = HedgeStrategy.deltaHedge;
    }

    public BlackScholesHedgedPortfolio(double d, double d2, double d3, double d4, double d5, double d6, HedgeStrategy hedgeStrategy) {
        this.maturity = d;
        this.strike = d2;
        this.riskFreeRate = d3;
        this.volatility = d4;
        this.hedgeOptionMaturity = d5;
        this.hedgeOptionStrike = d6;
        this.hedgeStrategy = hedgeStrategy;
    }

    @Override
    public RandomVariableInterface getValue(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) throws CalculationException {
        double d2;
        double d3;
        int n;
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2;
        int n2 = assetModelMonteCarloSimulationInterface.getTimeIndex(d);
        int n3 = assetModelMonteCarloSimulationInterface.getNumberOfPaths();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        RandomVariableInterface randomVariableInterface3 = assetModelMonteCarloSimulationInterface.getAssetValue(0.0, 0);
        double d4 = randomVariableInterface3.get(0);
        double d5 = AnalyticFormulas.blackScholesOptionValue(d4, this.riskFreeRate, this.volatility, this.maturity, this.strike);
        Arrays.fill(dArray2, d5);
        Arrays.fill(dArray, 0.0);
        Arrays.fill(dArray3, 0.0);
        for (int i = 0; i < n2; ++i) {
            randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getAssetValue(i, 0);
            randomVariableInterface = assetModelMonteCarloSimulationInterface.getNumeraire(i);
            for (n = 0; n < assetModelMonteCarloSimulationInterface.getNumberOfPaths(); ++n) {
                double d6;
                d3 = randomVariableInterface2.get(n);
                d2 = randomVariableInterface.get(n);
                double d7 = AnalyticFormulas.blackScholesOptionDelta(d3, this.riskFreeRate, this.volatility, this.maturity - assetModelMonteCarloSimulationInterface.getTime(i), this.strike);
                double d8 = 0.0;
                if (this.hedgeOptionStrike != 0.0) {
                    d8 = AnalyticFormulas.blackScholesOptionGamma(d3, this.riskFreeRate, this.volatility, this.maturity - assetModelMonteCarloSimulationInterface.getTime(i), this.strike);
                }
                double d9 = 0.0;
                if (this.hedgeOptionStrike != 0.0) {
                    d9 = AnalyticFormulas.blackScholesOptionVega(d3, this.riskFreeRate, this.volatility, this.maturity - assetModelMonteCarloSimulationInterface.getTime(i), this.strike) / (this.maturity - assetModelMonteCarloSimulationInterface.getTime(i));
                }
                double d10 = AnalyticFormulas.blackScholesOptionValue(d3, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - assetModelMonteCarloSimulationInterface.getTime(i), this.hedgeOptionStrike);
                double d11 = AnalyticFormulas.blackScholesOptionDelta(d3, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - assetModelMonteCarloSimulationInterface.getTime(i), this.hedgeOptionStrike);
                double d12 = AnalyticFormulas.blackScholesOptionGamma(d3, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - assetModelMonteCarloSimulationInterface.getTime(i), this.hedgeOptionStrike);
                double d13 = AnalyticFormulas.blackScholesOptionVega(d3, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - assetModelMonteCarloSimulationInterface.getTime(i), this.hedgeOptionStrike) / (this.hedgeOptionMaturity - assetModelMonteCarloSimulationInterface.getTime(i));
                double d14 = 0.0;
                switch (this.hedgeStrategy) {
                    case deltaGammaHedge: {
                        d14 = d8 / d12;
                        break;
                    }
                    case deltaVegaHedge: {
                        d14 = d9 / d13;
                        break;
                    }
                    default: {
                        d14 = 0.0;
                    }
                }
                if (Double.isNaN(d14) || Double.isInfinite(d14) || this.maturity - assetModelMonteCarloSimulationInterface.getTime(i) < 0.15) {
                    d14 = 0.0;
                }
                double d15 = d14 - dArray3[n];
                double d16 = d7 -= d14 * d11;
                double d17 = d16 - dArray[n];
                double d18 = -(d17 * d3 + d15 * d10) / d2;
                dArray2[n] = d6 = dArray2[n] + d18;
                dArray[n] = d16;
                dArray3[n] = d14;
            }
        }
        double[] dArray4 = new double[n3];
        randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getAssetValue(n2, 0);
        randomVariableInterface = assetModelMonteCarloSimulationInterface.getNumeraire(n2);
        for (n = 0; n < randomVariableInterface2.size(); ++n) {
            d3 = randomVariableInterface2.get(n);
            d2 = this.hedgeStrategy.equals((Object)HedgeStrategy.deltaHedge) ? 0.0 : AnalyticFormulas.blackScholesOptionValue(d3, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - assetModelMonteCarloSimulationInterface.getTime(n2), this.hedgeOptionStrike);
            dArray4[n] = dArray2[n] * randomVariableInterface.get(n) + dArray[n] * d3 + dArray3[n] * d2;
        }
        return new RandomVariable(d, dArray4);
    }

    public static enum HedgeStrategy {
        deltaHedge,
        deltaGammaHedge,
        deltaVegaHedge;

    }
}

