/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class BlackScholesDeltaHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double riskFreeRate;
    private final double volatility;

    public BlackScholesDeltaHedgedPortfolio(double d, double d2, double d3, double d4) {
        this.maturity = d;
        this.strike = d2;
        this.riskFreeRate = d3;
        this.volatility = d4;
    }

    @Override
    public RandomVariableInterface getValue(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2;
        int n = assetModelMonteCarloSimulationInterface.getTimeIndex(d);
        RandomVariableInterface randomVariableInterface3 = assetModelMonteCarloSimulationInterface.getAssetValue(0.0, 0);
        RandomVariableInterface randomVariableInterface4 = assetModelMonteCarloSimulationInterface.getNumeraire(0.0);
        RandomVariableInterface randomVariableInterface5 = AnalyticFormulas.blackScholesGeneralizedOptionValue(randomVariableInterface3.mult(Math.exp(this.riskFreeRate * (this.maturity - 0.0))), assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.volatility), this.maturity - 0.0, this.strike, assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(Math.exp(-this.riskFreeRate * (this.maturity - 0.0))));
        RandomVariableInterface randomVariableInterface6 = randomVariableInterface5.div(randomVariableInterface4);
        RandomVariableInterface randomVariableInterface7 = assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        for (int i = 0; i < n; ++i) {
            RandomVariableInterface randomVariableInterface8;
            RandomVariableInterface randomVariableInterface9;
            randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getAssetValue(i, 0);
            randomVariableInterface = assetModelMonteCarloSimulationInterface.getNumeraire(i);
            RandomVariableInterface randomVariableInterface10 = randomVariableInterface9 = AnalyticFormulas.blackScholesOptionDelta(randomVariableInterface2, assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.riskFreeRate), assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.volatility), this.maturity - assetModelMonteCarloSimulationInterface.getTime(i), this.strike);
            RandomVariableInterface randomVariableInterface11 = randomVariableInterface10.sub(randomVariableInterface7);
            RandomVariableInterface randomVariableInterface12 = randomVariableInterface11.mult(randomVariableInterface2).div(randomVariableInterface);
            randomVariableInterface6 = randomVariableInterface8 = randomVariableInterface6.sub(randomVariableInterface12);
            randomVariableInterface7 = randomVariableInterface10;
        }
        RandomVariableInterface randomVariableInterface13 = assetModelMonteCarloSimulationInterface.getAssetValue(d, 0);
        randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getNumeraire(d);
        randomVariableInterface = randomVariableInterface6.mult(randomVariableInterface2).add(randomVariableInterface7.mult(randomVariableInterface13));
        return randomVariableInterface;
    }
}

