/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class AsianOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final TimeDiscretizationInterface timesForAveraging;

    public AsianOption(double d, double d2, TimeDiscretizationInterface timeDiscretizationInterface) {
        this.maturity = d;
        this.strike = d2;
        this.timesForAveraging = timeDiscretizationInterface;
    }

    @Override
    public RandomVariableInterface getValue(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        Object object = this.timesForAveraging.iterator();
        while (object.hasNext()) {
            double d2 = (Double)object.next();
            randomVariableInterface = assetModelMonteCarloSimulationInterface.getAssetValue(d2, 0);
            randomVariableInterface2 = randomVariableInterface2.add(randomVariableInterface);
        }
        randomVariableInterface2 = randomVariableInterface2.div(this.timesForAveraging.getNumberOfTimes());
        object = randomVariableInterface2.sub(this.strike).floor(0.0);
        RandomVariableInterface randomVariableInterface3 = assetModelMonteCarloSimulationInterface.getNumeraire(this.maturity);
        RandomVariableInterface randomVariableInterface4 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(this.maturity);
        object = object.div(randomVariableInterface3).mult(randomVariableInterface4);
        randomVariableInterface = assetModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface5 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        object = object.mult(randomVariableInterface).div(randomVariableInterface5);
        return object;
    }
}

