/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class CorrelatedBrownianMotion
implements BrownianMotionInterface {
    private BrownianMotionInterface uncollelatedFactors;
    private double[][] factorLoadings;

    public CorrelatedBrownianMotion(BrownianMotionInterface brownianMotionInterface, double[][] dArray) {
        this.uncollelatedFactors = brownianMotionInterface;
        this.factorLoadings = dArray;
    }

    @Override
    public RandomVariableInterface getBrownianIncrement(int n, int n2) {
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0);
        for (int i = 0; i < this.factorLoadings[n2].length; ++i) {
            if (this.factorLoadings[n2][i] == 0.0) continue;
            RandomVariableInterface randomVariableInterface2 = this.uncollelatedFactors.getBrownianIncrement(n, i);
            randomVariableInterface = randomVariableInterface.addProduct(randomVariableInterface2, this.factorLoadings[n2][i]);
        }
        return randomVariableInterface;
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.uncollelatedFactors.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.factorLoadings.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.uncollelatedFactors.getNumberOfPaths();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.uncollelatedFactors.getRandomVariableForConstant(d);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int n) {
        return new CorrelatedBrownianMotion(this.uncollelatedFactors.getCloneWithModifiedSeed(n), this.factorLoadings);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface timeDiscretizationInterface) {
        return new CorrelatedBrownianMotion(this.uncollelatedFactors.getCloneWithModifiedTimeDiscretization(timeDiscretizationInterface), this.factorLoadings);
    }
}

