/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;

public class IndexCurveFromDiscountCurve
extends AbstractCurve
implements CurveInterface {
    private final double indexValue;
    private final DiscountCurveInterface discountCurve;

    public IndexCurveFromDiscountCurve(String string, double d, DiscountCurveInterface discountCurveInterface) {
        super(string, discountCurveInterface.getReferenceDate());
        this.indexValue = d;
        this.discountCurve = discountCurveInterface;
    }

    @Override
    public double[] getParameter() {
        return this.discountCurve.getParameter();
    }

    @Override
    public void setParameter(double[] dArray) {
        this.discountCurve.setParameter(dArray);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        return this.indexValue / this.discountCurve.getDiscountFactor(analyticModelInterface, d);
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

