/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.DiscountCurveNelsonSiegelSvensson;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import net.finmath.time.daycount.DayCountConventionInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class ForwardCurveNelsonSiegelSvensson
extends AbstractCurve
implements Serializable,
ForwardCurveInterface {
    private static final long serialVersionUID = 8024640795839972709L;
    private String paymentOffsetCode;
    private BusinessdayCalendarInterface paymentBusinessdayCalendar;
    private BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention;
    private DayCountConventionInterface daycountConvention;
    private double periodOffset = 0.0;
    private DiscountCurveNelsonSiegelSvensson discountCurve;

    public ForwardCurveNelsonSiegelSvensson(String string, Calendar calendar, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, DayCountConventionInterface dayCountConventionInterface, double[] dArray, double d, double d2) {
        super(string, calendar);
        this.paymentOffsetCode = string2;
        this.paymentBusinessdayCalendar = businessdayCalendarInterface;
        this.paymentDateRollConvention = dateRollConvention;
        this.daycountConvention = dayCountConventionInterface;
        this.periodOffset = d2;
        this.discountCurve = new DiscountCurveNelsonSiegelSvensson(string, calendar, dArray, d);
    }

    public ForwardCurveNelsonSiegelSvensson(String string, Calendar calendar, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, DayCountConventionInterface dayCountConventionInterface, double[] dArray, double d) {
        this(string, calendar, string2, businessdayCalendarInterface, dateRollConvention, dayCountConventionInterface, dArray, d, 0.0);
    }

    @Override
    public double getForward(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getForward(analyticModelInterface, d, this.getPaymentOffset(d + this.periodOffset));
    }

    @Override
    public double getForward(AnalyticModelInterface analyticModelInterface, double d, double d2) {
        d2 = this.getPaymentOffset(d + this.periodOffset);
        double d3 = d2 * this.discountCurve.getTimeScaling();
        if (this.daycountConvention != null) {
            Calendar calendar = this.getDateFromModelTime(d + this.periodOffset);
            Calendar calendar2 = this.getDateFromModelTime(d + this.periodOffset + d2);
            d3 = Math.max(this.daycountConvention.getDaycountFraction(calendar, calendar2), 0.0027397260273972603);
        }
        return (this.discountCurve.getDiscountFactor(analyticModelInterface, d + this.periodOffset) / this.discountCurve.getDiscountFactor(analyticModelInterface, d + this.periodOffset + d2) - 1.0) / d3;
    }

    @Override
    public String getDiscountCurveName() {
        return null;
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return null;
    }

    @Override
    public ForwardCurveNelsonSiegelSvensson clone() throws CloneNotSupportedException {
        return (ForwardCurveNelsonSiegelSvensson)super.clone();
    }

    @Override
    public ForwardCurveNelsonSiegelSvensson getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getForward(analyticModelInterface, d, this.getPaymentOffset(d));
    }

    @Override
    public double[] getParameter() {
        return this.discountCurve.getParameter();
    }

    @Override
    public void setParameter(double[] dArray) {
        this.discountCurve.setParameter(dArray);
    }

    @Override
    public double getPaymentOffset(double d) {
        Calendar calendar = this.getDateFromModelTime(d);
        Calendar calendar2 = this.paymentBusinessdayCalendar.getAdjustedDate(calendar, this.paymentOffsetCode, this.paymentDateRollConvention);
        double d2 = new DayCountConvention_ACT_365().getDaycountFraction(this.getReferenceDate(), calendar2);
        return d2 - d;
    }

    private Calendar getDateFromModelTime(double d) {
        Calendar calendar = (Calendar)this.getReferenceDate().clone();
        calendar.add(6, (int)Math.round(d * 365.0));
        return calendar;
    }
}

