/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;

public class DiscountCurveFromForwardCurve
extends AbstractCurve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = -4126228588123963885L;
    private String forwardCurveName;
    private ForwardCurveInterface forwardCurve;
    private final double timeScaling;

    public DiscountCurveFromForwardCurve(String string, double d) {
        super("DiscountCurveFromForwardCurve(" + string + ")", null);
        this.forwardCurveName = string;
        this.timeScaling = d;
    }

    public DiscountCurveFromForwardCurve(ForwardCurveInterface forwardCurveInterface, double d) {
        super("DiscountCurveFromForwardCurve" + forwardCurveInterface.getName() + ")", null);
        this.forwardCurve = forwardCurveInterface;
        this.timeScaling = d;
    }

    public DiscountCurveFromForwardCurve(String string) {
        this(string, 1.0);
    }

    public DiscountCurveFromForwardCurve(ForwardCurveInterface forwardCurveInterface) {
        this(forwardCurveInterface, 1.0);
    }

    @Override
    public double getDiscountFactor(double d) {
        return this.getDiscountFactor(null, d);
    }

    @Override
    public double getDiscountFactor(AnalyticModelInterface analyticModelInterface, double d) {
        ForwardCurveInterface forwardCurveInterface = this.forwardCurve != null ? this.forwardCurve : analyticModelInterface.getForwardCurve(this.forwardCurveName);
        if (forwardCurveInterface == null) {
            throw new IllegalArgumentException("No forward curve given and no forward curve found in the model under the name " + this.forwardCurveName + ".");
        }
        double d2 = 1.0;
        double d3 = 0.0;
        for (double d4 = 0.0; d4 < d; d4 += d3) {
            d3 = forwardCurveInterface.getPaymentOffset(d4);
            if (d3 <= 0.0) {
                throw new RuntimeException("Trying to calculate a discount curve from a forward curve with non-positive payment offset.");
            }
            d2 /= 1.0 + forwardCurveInterface.getForward(analyticModelInterface, d4) * Math.min(d3, d - d4) * this.timeScaling;
        }
        return d2;
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getDiscountFactor(analyticModelInterface, d);
    }

    @Override
    public double[] getParameter() {
        return null;
    }

    @Override
    public void setParameter(double[] dArray) {
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.forwardCurve == null ? 0 : this.forwardCurve.hashCode());
        n = 31 * n + (this.forwardCurveName == null ? 0 : this.forwardCurveName.hashCode());
        long l = Double.doubleToLongBits(this.timeScaling);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DiscountCurveFromForwardCurve discountCurveFromForwardCurve = (DiscountCurveFromForwardCurve)object;
        if (this.forwardCurve == null ? discountCurveFromForwardCurve.forwardCurve != null : !this.forwardCurve.equals(discountCurveFromForwardCurve.forwardCurve)) {
            return false;
        }
        if (this.forwardCurveName == null ? discountCurveFromForwardCurve.forwardCurveName != null : !this.forwardCurveName.equals(discountCurveFromForwardCurve.forwardCurveName)) {
            return false;
        }
        return Double.doubleToLongBits(this.timeScaling) == Double.doubleToLongBits(discountCurveFromForwardCurve.timeScaling);
    }
}

