/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import net.finmath.compatibility.java.util.function.DoubleUnaryOperator;
import net.finmath.fouriermethod.CharacteristicFunctionInterface;
import net.finmath.fouriermethod.models.ProcessCharacteristicFunctionInterface;
import net.finmath.integration.SimpsonRealIntegrator;
import org.apache.commons.math3.complex.Complex;

public abstract class AbstractProductFourierTransform
implements CharacteristicFunctionInterface {
    public double getValue(ProcessCharacteristicFunctionInterface processCharacteristicFunctionInterface) {
        final CharacteristicFunctionInterface characteristicFunctionInterface = processCharacteristicFunctionInterface.apply(this.getMaturity());
        final AbstractProductFourierTransform abstractProductFourierTransform = this;
        final double d = 0.5 * this.getIntegrationDomainImagUpperBound() + this.getIntegrationDomainImagLowerBound();
        DoubleUnaryOperator doubleUnaryOperator = new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double d2) {
                Complex complex = new Complex(d2, d);
                return ((Complex)characteristicFunctionInterface.apply(complex.negate())).multiply((Complex)abstractProductFourierTransform.apply(complex)).getReal();
            }
        };
        SimpsonRealIntegrator simpsonRealIntegrator = new SimpsonRealIntegrator(-100.0, 100.0, 20000, true);
        return simpsonRealIntegrator.integrate(doubleUnaryOperator) / 2.0 / Math.PI;
    }

    public abstract double getMaturity();

    public abstract double getIntegrationDomainImagLowerBound();

    public abstract double getIntegrationDomainImagUpperBound();
}

