/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod;

import net.finmath.exception.CalculationException;
import net.finmath.fouriermethod.models.BlackScholesModel;
import net.finmath.fouriermethod.products.EuropeanOption;
import net.finmath.functions.AnalyticFormulas;
import org.junit.Assert;
import org.junit.Test;

public class BlackScholesCallOptionTest {
    private static final double initialValue = 100.0;
    private static final double volatility = 0.25;
    private static final double riskFreeRate = 0.05;
    private static final double maturity = 1.0;
    private static final double strike = 95.0;

    @Test
    public void test() throws CalculationException {
        BlackScholesModel blackScholesModel = new BlackScholesModel(100.0, 0.05, 0.25);
        EuropeanOption europeanOption = new EuropeanOption(1.0, 95.0);
        long l = System.currentTimeMillis();
        double d = europeanOption.getValue(blackScholesModel);
        long l2 = System.currentTimeMillis();
        double d2 = AnalyticFormulas.blackScholesOptionValue(100.0, 0.05, 0.25, 1.0, 95.0);
        double d3 = d - d2;
        System.out.println("Result: " + d + ". \tError: " + d3 + "." + ". \tCalculation time: " + (double)(l2 - l) / 1000.0 + " sec.");
        Assert.assertEquals((String)"Value", (double)d2, (double)d, (double)1.0E-7);
    }
}

