/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.xmlparser.CoreParser;
import org.apache.lucene.xmlparser.CorePlusExtensionsParser;
import org.apache.lucene.xmlparser.ParserException;

public class TestParser
extends TestCase {
    CoreParser builder;
    static Directory dir;
    Analyzer analyzer = new StandardAnalyzer();
    IndexReader reader;
    private IndexSearcher searcher;
    boolean printResults = false;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new CorePlusExtensionsParser(this.analyzer, new QueryParser("contents", this.analyzer));
        if (dir == null) {
            BufferedReader d = new BufferedReader(new InputStreamReader(TestParser.class.getResourceAsStream("reuters21578.txt")));
            dir = new RAMDirectory();
            IndexWriter writer = new IndexWriter(dir, this.analyzer, true);
            String line = d.readLine();
            while (line != null) {
                int endOfDate = line.indexOf(9);
                String date = line.substring(0, endOfDate).trim();
                String content = line.substring(endOfDate).trim();
                Document doc = new Document();
                doc.add(new Field("date", date, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add(new Field("contents", content, Field.Store.YES, Field.Index.TOKENIZED));
                writer.addDocument(doc);
                line = d.readLine();
            }
            d.close();
            writer.close();
        }
        this.reader = IndexReader.open(dir);
        this.searcher = new IndexSearcher(this.reader);
    }

    protected void tearDown() throws Exception {
        this.reader.close();
        this.searcher.close();
    }

    public void testSimpleXML() throws ParserException, IOException {
        Query q = this.parse("TermQuery.xml");
        this.dumpResults("TermQuery", q, 5);
    }

    public void testSimpleTermsQueryXML() throws ParserException, IOException {
        Query q = this.parse("TermsQuery.xml");
        this.dumpResults("TermsQuery", q, 5);
    }

    public void testBooleanQueryXML() throws ParserException, IOException {
        Query q = this.parse("BooleanQuery.xml");
        this.dumpResults("BooleanQuery", q, 5);
    }

    public void testRangeFilterQueryXML() throws ParserException, IOException {
        Query q = this.parse("RangeFilterQuery.xml");
        this.dumpResults("RangeFilter", q, 5);
    }

    public void testUserQueryXML() throws ParserException, IOException {
        Query q = this.parse("UserInputQuery.xml");
        this.dumpResults("UserInput with Filter", q, 5);
    }

    public void testLikeThisQueryXML() throws Exception {
        Query q = this.parse("LikeThisQuery.xml");
        this.dumpResults("like this", q, 5);
    }

    public void testBoostingQueryXML() throws Exception {
        Query q = this.parse("BoostingQuery.xml");
        this.dumpResults("boosting ", q, 5);
    }

    public void testFuzzyLikeThisQueryXML() throws Exception {
        Query q = this.parse("FuzzyLikeThisQuery.xml");
        if (this.printResults) {
            System.out.println(q.rewrite(this.reader));
        }
        this.dumpResults("FuzzyLikeThis", q, 5);
    }

    public void testTermsFilterXML() throws Exception {
        Query q = this.parse("TermsFilterQuery.xml");
        this.dumpResults("Terms Filter", q, 5);
    }

    public void testSpanTermXML() throws Exception {
        Query q = this.parse("SpanQuery.xml");
        this.dumpResults("Span Query", q, 5);
    }

    public void testConstantScoreQueryXML() throws Exception {
        Query q = this.parse("ConstantScoreQuery.xml");
        this.dumpResults("ConstantScoreQuery", q, 5);
    }

    public void testMatchAllDocsPlusFilterXML() throws ParserException, IOException {
        Query q = this.parse("MatchAllDocsQuery.xml");
        this.dumpResults("MatchAllDocsQuery with range filter", q, 5);
    }

    public void testBooleanFilterXML() throws ParserException, IOException {
        Query q = this.parse("BooleanFilter.xml");
        this.dumpResults("Boolean filter", q, 5);
    }

    public void testNestedBooleanQuery() throws ParserException, IOException {
        Query q = this.parse("NestedBooleanQuery.xml");
        this.dumpResults("Nested Boolean query", q, 5);
    }

    public void testCachedFilterXML() throws ParserException, IOException {
        Query q = this.parse("CachedFilter.xml");
        this.dumpResults("Cached filter", q, 5);
    }

    public void testDuplicateFilterQueryXML() throws ParserException, IOException {
        Query q = this.parse("DuplicateFilterQuery.xml");
        Hits h = this.searcher.search(q);
        TestParser.assertEquals((String)"DuplicateFilterQuery should produce 1 result ", (int)1, (int)h.length());
    }

    private Query parse(String xmlFileName) throws ParserException, IOException {
        InputStream xmlStream = TestParser.class.getResourceAsStream(xmlFileName);
        Query result = this.builder.parse(xmlStream);
        xmlStream.close();
        return result;
    }

    private void dumpResults(String qType, Query q, int numDocs) throws IOException {
        Hits h = this.searcher.search(q);
        TestParser.assertTrue((String)(qType + " should produce results "), (h.length() > 0 ? 1 : 0) != 0);
        if (this.printResults) {
            System.out.println("=========" + qType + "============");
            for (int i = 0; i < Math.min(numDocs, h.length()); ++i) {
                Document ldoc = h.doc(i);
                System.out.println("[" + ldoc.get("date") + "]" + ldoc.get("contents"));
            }
            System.out.println();
        }
    }
}

