/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.wikipedia.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.wikipedia.analysis.WikipediaTokenizerImpl;

public class WikipediaTokenizer
extends Tokenizer {
    public static final String INTERNAL_LINK = "il";
    public static final String EXTERNAL_LINK = "el";
    public static final String EXTERNAL_LINK_URL = "elu";
    public static final String CITATION = "ci";
    public static final String CATEGORY = "c";
    public static final String BOLD = "b";
    public static final String ITALICS = "i";
    public static final String BOLD_ITALICS = "bi";
    public static final String HEADING = "h";
    public static final String SUB_HEADING = "sh";
    public static final int ALPHANUM_ID = 0;
    public static final int APOSTROPHE_ID = 1;
    public static final int ACRONYM_ID = 2;
    public static final int COMPANY_ID = 3;
    public static final int EMAIL_ID = 4;
    public static final int HOST_ID = 5;
    public static final int NUM_ID = 6;
    public static final int CJ_ID = 7;
    public static final int INTERNAL_LINK_ID = 8;
    public static final int EXTERNAL_LINK_ID = 9;
    public static final int CITATION_ID = 10;
    public static final int CATEGORY_ID = 11;
    public static final int BOLD_ID = 12;
    public static final int ITALICS_ID = 13;
    public static final int BOLD_ITALICS_ID = 14;
    public static final int HEADING_ID = 15;
    public static final int SUB_HEADING_ID = 16;
    public static final int EXTERNAL_LINK_URL_ID = 17;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "il", "el", "ci", "c", "b", "i", "bi", "h", "sh", "elu"};
    public static final String[] tokenImage = TOKEN_TYPES;
    public static final int TOKENS_ONLY = 0;
    public static final int UNTOKENIZED_ONLY = 1;
    public static final int BOTH = 2;
    private final WikipediaTokenizerImpl scanner;

    void setInput(Reader reader) {
        this.input = reader;
    }

    public WikipediaTokenizer(Reader input) {
        this.input = input;
        this.scanner = new WikipediaTokenizerImpl(input);
    }

    @Override
    public Token next(Token result) throws IOException {
        int tokenType = this.scanner.getNextToken();
        if (tokenType == -1) {
            return null;
        }
        this.scanner.getText(result, tokenType);
        int start = this.scanner.yychar();
        result.setStartOffset(start);
        result.setEndOffset(start + result.termLength());
        result.setPositionIncrement(this.scanner.getPositionIncrement());
        result.setType(WikipediaTokenizerImpl.TOKEN_TYPES[tokenType]);
        return result;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
    }

    @Override
    public void reset(Reader reader) throws IOException {
        this.input = reader;
        this.reset();
    }
}

