/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import junit.framework.TestCase;
import org.apache.lucene.swing.models.BaseTableModel;
import org.apache.lucene.swing.models.DataStore;
import org.apache.lucene.swing.models.RestaurantInfo;
import org.apache.lucene.swing.models.TableSearcher;

public class TestUpdatingTable
extends TestCase {
    private BaseTableModel baseTableModel;
    private TableSearcher tableSearcher;
    RestaurantInfo infoToAdd1;
    RestaurantInfo infoToAdd2;

    protected void setUp() throws Exception {
        this.baseTableModel = new BaseTableModel(DataStore.getRestaurants());
        this.tableSearcher = new TableSearcher(this.baseTableModel);
        this.infoToAdd1 = new RestaurantInfo();
        this.infoToAdd1.setName("Pino's");
        this.infoToAdd1.setType("Italian");
        this.infoToAdd2 = new RestaurantInfo();
        this.infoToAdd2.setName("Pino's");
        this.infoToAdd2.setType("Italian");
    }

    public void testAddWithoutSearch() {
        TestUpdatingTable.assertEquals((int)this.baseTableModel.getRowCount(), (int)this.tableSearcher.getRowCount());
        int count = this.tableSearcher.getRowCount();
        this.baseTableModel.addRow(this.infoToAdd1);
        TestUpdatingTable.assertEquals((int)(++count), (int)this.tableSearcher.getRowCount());
    }

    public void testRemoveWithoutSearch() {
        TestUpdatingTable.assertEquals((int)this.baseTableModel.getRowCount(), (int)this.tableSearcher.getRowCount());
        int count = this.tableSearcher.getRowCount();
        this.baseTableModel.addRow(this.infoToAdd1);
        this.baseTableModel.removeRow(this.infoToAdd1);
        TestUpdatingTable.assertEquals((int)count, (int)this.tableSearcher.getRowCount());
    }

    public void testAddWithSearch() {
        TestUpdatingTable.assertEquals((int)this.baseTableModel.getRowCount(), (int)this.tableSearcher.getRowCount());
        this.tableSearcher.search("pino's");
        int count = this.tableSearcher.getRowCount();
        this.baseTableModel.addRow(this.infoToAdd2);
        TestUpdatingTable.assertEquals((int)(++count), (int)this.tableSearcher.getRowCount());
    }

    public void testRemoveWithSearch() {
        TestUpdatingTable.assertEquals((int)this.baseTableModel.getRowCount(), (int)this.tableSearcher.getRowCount());
        this.baseTableModel.addRow(this.infoToAdd1);
        this.tableSearcher.search("pino's");
        int count = this.tableSearcher.getRowCount();
        this.baseTableModel.removeRow(this.infoToAdd1);
        TestUpdatingTable.assertEquals((int)(--count), (int)this.tableSearcher.getRowCount());
    }
}

