/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.apache.lucene.swing.models.RestaurantInfo;

public class BaseTableModel
extends AbstractTableModel {
    private ArrayList columnNames = new ArrayList();
    private ArrayList rows = new ArrayList();

    public BaseTableModel(Iterator data) {
        this.columnNames.add("Name");
        this.columnNames.add("Type");
        this.columnNames.add("Phone");
        this.columnNames.add("Street");
        this.columnNames.add("City");
        this.columnNames.add("State");
        this.columnNames.add("Zip");
        while (data.hasNext()) {
            Object nextRow = data.next();
            this.rows.add(nextRow);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public void addRow(RestaurantInfo info) {
        this.rows.add(info);
        this.fireTableDataChanged();
    }

    public void removeRow(RestaurantInfo info) {
        this.rows.remove(info);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RestaurantInfo restaurantInfo = (RestaurantInfo)this.rows.get(rowIndex);
        if (columnIndex == 0) {
            return restaurantInfo.getName();
        }
        if (columnIndex == 1) {
            return restaurantInfo.getType();
        }
        if (columnIndex == 2) {
            return restaurantInfo.getPhone();
        }
        if (columnIndex == 3) {
            return restaurantInfo.getStreet();
        }
        if (columnIndex == 4) {
            return restaurantInfo.getCity();
        }
        if (columnIndex == 5) {
            return restaurantInfo.getState();
        }
        if (columnIndex == 6) {
            return restaurantInfo.getZip();
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex).toString();
    }
}

