/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DuplicateFilter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class DuplicateFilterTest
extends TestCase {
    private static final String KEY_FIELD = "url";
    private RAMDirectory directory;
    private IndexReader reader;
    TermQuery tq = new TermQuery(new Term("text", "lucene"));
    private IndexSearcher searcher;

    protected void setUp() throws Exception {
        this.directory = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)this.directory, (Analyzer)new StandardAnalyzer(), true);
        this.addDoc(writer, "http://lucene.apache.org", "lucene 1.4.3 available", "20040101");
        this.addDoc(writer, "http://lucene.apache.org", "New release pending", "20040102");
        this.addDoc(writer, "http://lucene.apache.org", "Lucene 1.9 out now", "20050101");
        this.addDoc(writer, "http://www.bar.com", "Local man bites dog", "20040101");
        this.addDoc(writer, "http://www.bar.com", "Dog bites local man", "20040102");
        this.addDoc(writer, "http://www.bar.com", "Dog uses Lucene", "20050101");
        this.addDoc(writer, "http://lucene.apache.org", "Lucene 2.0 out", "20050101");
        this.addDoc(writer, "http://lucene.apache.org", "Oops. Lucene 2.1 out", "20050102");
        writer.close();
        this.reader = IndexReader.open(this.directory);
        this.searcher = new IndexSearcher(this.reader);
    }

    protected void tearDown() throws Exception {
        this.reader.close();
        this.searcher.close();
        this.directory.close();
    }

    private void addDoc(IndexWriter writer, String url, String text, String date) throws IOException {
        Document doc = new Document();
        doc.add(new Field(KEY_FIELD, url, Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add(new Field("text", text, Field.Store.YES, Field.Index.TOKENIZED));
        doc.add(new Field("date", date, Field.Store.YES, Field.Index.TOKENIZED));
        writer.addDocument(doc);
    }

    public void testDefaultFilter() throws Throwable {
        DuplicateFilter df = new DuplicateFilter(KEY_FIELD);
        HashSet<String> results = new HashSet<String>();
        Hits h = this.searcher.search((Query)this.tq, df);
        for (int i = 0; i < h.length(); ++i) {
            Document d = h.doc(i);
            String url = d.get(KEY_FIELD);
            DuplicateFilterTest.assertFalse((String)"No duplicate urls should be returned", (boolean)results.contains(url));
            results.add(url);
        }
    }

    public void testNoFilter() throws Throwable {
        HashSet<String> results = new HashSet<String>();
        Hits h = this.searcher.search(this.tq);
        DuplicateFilterTest.assertTrue((String)"Default searching should have found some matches", (h.length() > 0 ? 1 : 0) != 0);
        boolean dupsFound = false;
        for (int i = 0; i < h.length(); ++i) {
            Document d = h.doc(i);
            String url = d.get(KEY_FIELD);
            if (!dupsFound) {
                dupsFound = results.contains(url);
            }
            results.add(url);
        }
        DuplicateFilterTest.assertTrue((String)"Default searching should have found duplicate urls", (boolean)dupsFound);
    }

    public void testFastFilter() throws Throwable {
        DuplicateFilter df = new DuplicateFilter(KEY_FIELD);
        df.setProcessingMode(2);
        HashSet<String> results = new HashSet<String>();
        Hits h = this.searcher.search((Query)this.tq, df);
        DuplicateFilterTest.assertTrue((String)"Filtered searching should have found some matches", (h.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < h.length(); ++i) {
            Document d = h.doc(i);
            String url = d.get(KEY_FIELD);
            DuplicateFilterTest.assertFalse((String)"No duplicate urls should be returned", (boolean)results.contains(url));
            results.add(url);
        }
        DuplicateFilterTest.assertEquals((String)"Two urls found", (int)2, (int)results.size());
    }

    public void testKeepsLastFilter() throws Throwable {
        DuplicateFilter df = new DuplicateFilter(KEY_FIELD);
        df.setKeepMode(2);
        Hits h = this.searcher.search((Query)this.tq, df);
        DuplicateFilterTest.assertTrue((String)"Filtered searching should have found some matches", (h.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < h.length(); ++i) {
            Document d = h.doc(i);
            String url = d.get(KEY_FIELD);
            TermDocs td = this.reader.termDocs(new Term(KEY_FIELD, url));
            int lastDoc = 0;
            while (td.next()) {
                lastDoc = td.doc();
            }
            DuplicateFilterTest.assertEquals((String)"Duplicate urls should return last doc", (int)lastDoc, (int)h.id(i));
        }
    }

    public void testKeepsFirstFilter() throws Throwable {
        DuplicateFilter df = new DuplicateFilter(KEY_FIELD);
        df.setKeepMode(1);
        Hits h = this.searcher.search((Query)this.tq, df);
        DuplicateFilterTest.assertTrue((String)"Filtered searching should have found some matches", (h.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < h.length(); ++i) {
            Document d = h.doc(i);
            String url = d.get(KEY_FIELD);
            TermDocs td = this.reader.termDocs(new Term(KEY_FIELD, url));
            int lastDoc = 0;
            td.next();
            lastDoc = td.doc();
            DuplicateFilterTest.assertEquals((String)"Duplicate urls should return first doc", (int)lastDoc, (int)h.id(i));
        }
    }
}

