/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.SpanFilter;
import org.apache.lucene.search.SpanFilterResult;

public class CachingSpanFilter
extends SpanFilter {
    protected SpanFilter filter;
    protected transient Map cache;

    public CachingSpanFilter(SpanFilter filter) {
        this.filter = filter;
    }

    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        SpanFilterResult result = this.getCachedResult(reader);
        return result != null ? result.getBits() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpanFilterResult getCachedResult(IndexReader reader) throws IOException {
        SpanFilterResult result = null;
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Map map = this.cache;
        synchronized (map) {
            result = (SpanFilterResult)this.cache.get(reader);
            if (result == null) {
                result = this.filter.bitSpans(reader);
                this.cache.put(reader, result);
            }
        }
        return result;
    }

    @Override
    public SpanFilterResult bitSpans(IndexReader reader) throws IOException {
        return this.getCachedResult(reader);
    }

    public String toString() {
        return "CachingSpanFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingSpanFilter)) {
            return false;
        }
        return this.filter.equals(((CachingSpanFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

